﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker
{
    using NintendoWare.SoundMakerPlugin;
    using Runtime = NintendoWare.SoundRuntime;

    public class RuntimeNoteOnInfo : IRuntimeNoteOnInfo
    {
        private Runtime.NoteOnInfo noteOnInfo;

        public RuntimeNoteOnInfo(Runtime.NoteOnInfo noteOnInfo)
        {
            this.noteOnInfo = noteOnInfo;
        }

        public Runtime.NoteOnInfo NoteOnInfo
        {
            get
            {
                return this.noteOnInfo;
            }
        }

        public int PrgNo
        {
            get
            {
                return this.noteOnInfo.prgNo;
            }
        }

        public int Key
        {
            get
            {
                return this.noteOnInfo.key;
            }
        }

        public int Velocity
        {
            get
            {
                return this.noteOnInfo.velocity;
            }
        }
    }
}
