﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Preview
{
    using System;
    using System.Collections.ObjectModel;
    using NintendoWare.SoundFoundation.Projects;
    using Runtime = NintendoWare.SoundRuntime;

    /// <summary>
    ///
    /// </summary>
    public static class BiquadTypeEx
    {
        public static int ToRuntimeBiquadFilterType(this BiquadType value)
        {
            switch (value)
            {
                case BiquadType.INHERIT: return -1;
                case BiquadType.None: return 0;
                case BiquadType.LPF: return 1;
                case BiquadType.HPF: return 2;
                case BiquadType.BPF512: return 3;
                case BiquadType.BPF1024: return 4;
                case BiquadType.BPF2048: return 5;
                case BiquadType.USR0: return 64;
                case BiquadType.USR1: return 65;
                case BiquadType.USR2: return 66;
                case BiquadType.USR3: return 67;
                case BiquadType.USR4: return 68;
                case BiquadType.USR5: return 69;
                case BiquadType.USR6: return 70;
                case BiquadType.USR7: return 71;
                case BiquadType.USR8: return 72;
                case BiquadType.USR9: return 73;
                case BiquadType.USR10: return 74;
                case BiquadType.USR11: return 75;
                case BiquadType.USR12: return 76;
                case BiquadType.USR13: return 77;
                case BiquadType.USR14: return 78;
                case BiquadType.USR15: return 79;
                case BiquadType.USR16: return 80;
                case BiquadType.USR17: return 81;
                case BiquadType.USR18: return 82;
                case BiquadType.USR19: return 83;
                case BiquadType.USR20: return 84;
                case BiquadType.USR21: return 85;
                case BiquadType.USR22: return 86;
                case BiquadType.USR23: return 87;
                case BiquadType.USR24: return 88;
                case BiquadType.USR25: return 89;
                case BiquadType.USR26: return 90;
                case BiquadType.USR27: return 91;
                case BiquadType.USR28: return 92;
                case BiquadType.USR29: return 93;
                case BiquadType.USR30: return 94;
                case BiquadType.USR31: return 95;
                case BiquadType.USR32: return 96;
                case BiquadType.USR33: return 97;
                case BiquadType.USR34: return 98;
                case BiquadType.USR35: return 99;
                case BiquadType.USR36: return 100;
                case BiquadType.USR37: return 101;
                case BiquadType.USR38: return 102;
                case BiquadType.USR39: return 103;
                case BiquadType.USR40: return 104;
                case BiquadType.USR41: return 105;
                case BiquadType.USR42: return 106;
                case BiquadType.USR43: return 107;
                case BiquadType.USR44: return 108;
                case BiquadType.USR45: return 109;
                case BiquadType.USR46: return 110;
                case BiquadType.USR47: return 111;
                case BiquadType.USR48: return 112;
                case BiquadType.USR49: return 113;
                case BiquadType.USR50: return 114;
                case BiquadType.USR51: return 115;
                case BiquadType.USR52: return 116;
                case BiquadType.USR53: return 117;
                case BiquadType.USR54: return 118;
                case BiquadType.USR55: return 119;
                case BiquadType.USR56: return 120;
                case BiquadType.USR57: return 121;
                case BiquadType.USR58: return 122;
                case BiquadType.USR59: return 123;
                case BiquadType.USR60: return 124;
                case BiquadType.USR61: return 125;
                case BiquadType.USR62: return 126;
                case BiquadType.USR63: return 127;
            }

            throw new ArgumentException("invalid biquad type.");
        }
    }

    /// <summary>
    ///
    /// </summary>
    public abstract class PreviewChannelGeneric : IDisposable
    {
        public PreviewPlayerState State
        {
            get
            {
                if (null == Channel) { return PreviewPlayerState.Disabled; }
                if (!Channel.IsActive()) { return PreviewPlayerState.Stopped; }
                if (Channel.IsPause()) { return PreviewPlayerState.Paused; }

                return PreviewPlayerState.Playing;
            }
        }

        public abstract Runtime.ChannelCafe Channel { get; }

        protected abstract Runtime.WaveInfo WaveInfo { get; }

        protected virtual int PlaybackLength
        {
            get { return 0; }
        }

        public void Start()
        {
            if (null == Channel) { return; }

            if (Channel.IsActive())
            {
                Free();
            }

            Channel.Start(WaveInfo, PlaybackLength);
        }

        public void Pause(bool flag)
        {
            if (null == Channel) { return; }

            Channel.Pause(flag);
        }

        public void Stop()
        {
            if (null == Channel) { return; }

            Channel.NoteOff();
        }

        public void Dispose()
        {
            Free();
        }

        private void Free()
        {
            if (Channel == null ||
                !Channel.IsActive())
            {
                return;
            }

            Channel.Stop();
            Channel.FreeChannel();
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class PreviewChannelCollectionCafe : Collection<PreviewChannelGeneric> { }
}
