﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

class MidiIn
{
public:
    struct MidiMsg {
        BYTE status;
        BYTE data1;
        BYTE data2;
    };

    static const int MIDI_MSG_BUFFER_SIZE = 5120;

    MidiIn();
    ~MidiIn();

    bool Open( UINT deviceID );
    void Close();

    void Reset();

    bool IsActive( DWORD msec ) const;

    bool IsErrorOccuered() const { return mMidiMsgOverFlag; }
    void ResetErrorFlag() { mMidiMsgOverFlag = false; }

    bool ReadMidiMsg( MidiMsg* msg );

private:
    static void CALLBACK MidiInProcFunc(
        HMIDIIN hMidiIn,
        UINT wMsg,
        DWORD dwInstance,
        DWORD dwParam1,
        DWORD dwParam2
    );
    void MidiInProc(
        UINT wMsg,
        DWORD dwParam1,
        DWORD dwParam2
    );

    bool mMidiInActive;
    DWORD mLastMidiInTime;

    HMIDIIN mMidiInHandle;

    int mMidiMsgReadPos;
    int mMidiMsgWritePos;
    bool mMidiMsgOverFlag;
    MidiMsg mMidiMsgBuffer[ MIDI_MSG_BUFFER_SIZE ];

    CRITICAL_SECTION mCritSec;
};
