﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <crtdbg.h>

#include "SeqConvInclude.h"

// コンバータ情報
const extern ConverterInfo g_converterInfo =
    {
        "0.3.0"         // コンバータのバージョン
    };

// バイナリ情報
const extern BinaryInfo g_binaryInfo =
    {
        ".bfseq",       // バイナリファイルの拡張子
        'FSEQ',         // バイナリのシグネチャ
        0x00020000,     // バイナリのバージョン
    };

int main(int argc, char* argv[])
{
    int tmpDbgFlag = _CrtSetDbgFlag(_CRTDBG_REPORT_FLAG);
    tmpDbgFlag |= _CRTDBG_DELAY_FREE_MEM_DF;
    tmpDbgFlag |= _CRTDBG_LEAK_CHECK_DF;
    _CrtSetDbgFlag(tmpDbgFlag);

    return Run( argc, argv );
}
