﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Nintendo.Alto.Foundation.Communications
{
    /// <summary>
    /// HostIO チャンネル情報を格納します。
    /// </summary>
    public class HostIOChannelInfo
    {
        private readonly string name;
        private readonly int port;

        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="name">チャンネルの名前を指定します。</param>
        /// <param name="port">チャンネルのポート番号を指定します。</param>
        public HostIOChannelInfo(string name, int port)
        {
            this.name = name;
            this.port = port;
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// チャンネルの名前を取得します。
        /// </summary>
        public string Name
        {
            get { return this.name; }
        }

        /// <summary>
        /// チャンネルのポート番号を取得します。
        /// </summary>
        public int Port
        {
            get { return this.port; }
        }
    }
}
