﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

using NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat.Model;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat
{
    public class Nw4rSoundArchiveConvertSettings
    {
        #region ** 固定値

        public const string ElementName = "sound_archive_convert_settings";

        public const string WarningElementName = "warning_flags";

        #endregion

        private Nw4rSoundArchiveConvertWarningFlags _warningFlags = Nw4rSoundArchiveConvertWarningFlags.NoWarning;	// 警告フラグ

        #region ** プロパティ

        public Nw4rSoundArchiveConvertWarningFlags WarningFlags
        {
            get { return _warningFlags; }
            set { _warningFlags = value; }
        }

        #endregion

        #region ** メソッド

        internal static Nw4rSoundArchiveConvertSettings Parse(XmlDocument doc, XmlElement rootElem)
        {
            Nw4rSoundArchiveConvertSettings convertSettings = new Nw4rSoundArchiveConvertSettings();

            XmlElement targetElement = (XmlElement)rootElem.SelectSingleNode(WarningElementName);
            if (targetElement != null)
            {
                convertSettings._warningFlags = (Nw4rSoundArchiveConvertWarningFlags)uint.Parse(targetElement.InnerText);
            }

            return convertSettings;
        }

        internal XmlElement ToXmlElement(XmlDocument doc)
        {
            XmlElement rootElement = doc.CreateElement(ElementName);

            XmlElement element = doc.CreateElement(WarningElementName);
            element.InnerText = ((uint)_warningFlags).ToString();
            rootElement.AppendChild(element);

            return rootElement;
        }

        #endregion
    }
}
