﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat
{

    public class Nw4rBinarySeq
    {
        public List<LabelInfo> LabelInfoList = new List<LabelInfo>();

        public struct LabelInfo
        {
            public string Name;
            public uint SeqDataOffset;
        }

        public static Nw4rBinarySeq CreateFromFile(string filePath)
        {
            Nw4rBinarySeq binarySeq = new Nw4rBinarySeq();

            using (FileStream fileStream = File.OpenRead(filePath))
            {
                BinaryReader reader = BinaryReaderBigEndian.CreateInstance(fileStream, new System.Text.ASCIIEncoding());
                string fileChunk = new string(reader.ReadChars(4));
                if (fileChunk != "RSEQ")
                {
                    throw new Nw4rFileFormatException("Unexpcted file format \"" + filePath + "\"");
                }

                int byteOrder = reader.ReadUInt16();
                int version = reader.ReadUInt16();
                uint fileSize = reader.ReadUInt32();
                int headerSize = reader.ReadUInt16();
                int dataBlocks = reader.ReadUInt16();

                uint dataBlockOffset = reader.ReadUInt32();
                uint dataBlockSize = reader.ReadUInt32();
                uint labelBlockOffset = reader.ReadUInt32();
                uint labelBlockSize = reader.ReadUInt32();

                fileStream.Seek(labelBlockOffset, SeekOrigin.Begin);
                reader = BinaryReaderBigEndian.CreateInstance(fileStream, new System.Text.ASCIIEncoding());
                string chunkId = new string(reader.ReadChars(4));
                if (chunkId != "LABL")
                {
                    throw new Nw4rFileFormatException("Unexpcted chunk \"" + filePath + "\"");
                }
                uint chunkSize = reader.ReadUInt32();
                uint tableCount = reader.ReadUInt32();
                List<uint> offsetTable = new List<uint>();
                for (int i = 0; i < tableCount; i++)
                {
                    uint ofs = reader.ReadUInt32();
                    offsetTable.Add(ofs);
                }

                foreach (uint ofs in offsetTable)
                {
                    fileStream.Seek(ofs + labelBlockOffset + 8, SeekOrigin.Begin);
                    reader = BinaryReaderBigEndian.CreateInstance(fileStream, new System.Text.ASCIIEncoding());
                    uint seqDataOffset = reader.ReadUInt32();
                    uint nameLen = reader.ReadUInt32();
                    string labelName = new string(reader.ReadChars((int)nameLen));

                    LabelInfo labelInfo = new LabelInfo();
                    labelInfo.Name = labelName;
                    labelInfo.SeqDataOffset = seqDataOffset;

                    binarySeq.LabelInfoList.Add(labelInfo);
                }
            }

            return binarySeq;
        }
    }
}
