﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Xml;
    using System.Xml.Serialization;

    [Serializable]
    [XmlRoot("SoundSet", Namespace = XmlNamespaces.Base, IsNullable = false)]
    public class XmlSoundSetCtr : XmlComponent, IXmlComponentParent
    {
        [XmlArray("Items")]
        [XmlArrayItem("SoundSetItemFolder", Type = typeof(XmlSoundSetItemFolderCtr))]
        [XmlArrayItem("StreamSound", Type = typeof(XmlStreamSoundCtr))]
        [XmlArrayItem("WaveSound", Type = typeof(XmlWaveSoundCtr))]
        [XmlArrayItem("SequenceSound", Type = typeof(XmlSequenceSoundCtr))]
        [XmlArrayItem("SoundSetBank", Type = typeof(XmlSoundSetBank))]
        [XmlArrayItem("Player", Type = typeof(XmlPlayer))]
        [XmlArrayItem("WaveArchive", Type = typeof(XmlWaveArchive))]
        [XmlArrayItem("Group", Type = typeof(XmlGroup))]
        public List<XmlComponent> Items { get; set; }
    }
}
