﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.WaveExporter
{
    using System;
    using System.IO;
    using System.Collections.Generic;
    using System.Linq;
    using System.Reflection;
    using System.Text;
    using System.Threading;
    using System.Windows.Forms;
    using NintendoWare.SoundFoundation.Core.Threading;
    using NintendoWare.SoundFoundation.Utilities;
    using NintendoWare.SoundMaker.FileFormats;
    using NintendoWare.SoundMaker.Windows.Forms;
    using NintendoWare.SoundMakerPlugin;
    using SoundProjectWaveExporter.Resources;

    class Program
    {
        static int Main(string[] args)
        {
            EnvironmentUtility.RemoveMultipleEnvironmentVariables();
            Thread.CurrentThread.InitializeCurrentUICulture();

            // Load Plugin // exe のフォルダ以下の plugins フォルダから読み込みます。
            string exePath = Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
            try
            {
                var pm = new SoundMakerPluginManager(exePath + "\\plugins");
                pm.SetCurrentPlatform("Generic");
            }
            catch
            {
                MessageBox.Show(MessageResourceWaveExporter.Message_ErrorLoadPlugin);
                return 1;
            }
            WaveFileManager.Instance.SetCreateWaveFileInfo(SoundMakerPluginManager.Instance.CurrentSoundMakerPlugin.GetCreateWaveFileInfoDelegate());

            bool result = new FormsApplicationGeneric().Run(args);
            return result ? 0 : 1;
        }
    }
}
