﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.SoundFoundation;
using NintendoWare.SoundFoundation.Documents;
using NintendoWare.SoundFoundation.Projects;
using System;

namespace NintendoWare.SoundProjectUtility
{
    /// <summary>
    /// 各種サービスを生成するためのユーティリティを提供します。
    /// </summary>
    internal static class ServiceUtility
    {
        /// <summary>
        /// サウンド中間出力特性を生成します。
        /// </summary>
        /// <returns>サウンド中間出力特性を返します。</returns>
        internal static SoundIntermediateOutputTraits CreateIntermediateOutputTraits()
        {
            return new SoundIntermediateOutputTraits()
            {
                SoundProjectDocumentTypeName = Platforms.Any.SoundProjectDocument,
                SoundSetDocumentTypeName = Platforms.Any.SoundSetDocument,
                BankDocumentTypeName = Platforms.Any.BankDocument,
                SoundProjectFileExtension = SoundFileExtensions.SoundProjectFile,
                SoundSetFileExtension = SoundFileExtensions.SoundSetFile,
                BankFileExtension = SoundFileExtensions.BankFile,
                TextSequenceSoundFileExtension = SoundFileExtensions.TextSequenceSoundFile,
                BankIncludeFileExtension = SoundFileExtensions.BankIncludeFile,
                SoundIDCppHeaderFileExtension = SoundFileExtensions.SoundIDCppHeaderFile,
            };
        }

        /// <summary>
        /// ドキュメントサービス特性(読み取り専用)を生成します。
        /// </summary>
        /// <returns>ドキュメントサービス特性を返します。</returns>
        internal static IDocumentServiceTraits CreateReadOnlyDocumentServiceTraits()
        {
            var traits = new DocumentServiceTraits();

            // DocumentFactory
            traits.DocumentFactorys.Add(new SoundProjectDocumentFactory());
            traits.DocumentFactorys.Add(new SoundSetDocumentFactory());
            traits.DocumentFactorys.Add(new BankDocumentFactory());

            // DocumentReader
            traits.DocumentReaders.Add(new SoundProjectDocumentReader());
            traits.DocumentReaders.Add(new SoundSetDocumentReaderCommon(new SoundSetComponentFactory()));
            traits.DocumentReaders.Add(new BankDocumentReader());

            return traits;
        }

        /// <summary>
        /// ドキュメントサービス特性を生成します。
        /// </summary>
        /// <returns>ドキュメントサービス特性を返します。</returns>
        internal static IDocumentServiceTraits CreateDocumentServiceTraits()
        {
            var traits = new DocumentServiceTraits();

            // DocumentFactory
            traits.DocumentFactorys.Add(new SoundProjectDocumentFactory());
            traits.DocumentFactorys.Add(new SoundSetDocumentFactory());
            traits.DocumentFactorys.Add(new BankDocumentFactory());

            // DocumentReader
            traits.DocumentReaders.Add(new SoundProjectDocumentReader());
            traits.DocumentReaders.Add(new SoundSetDocumentReaderCommon(new SoundSetComponentFactory()));
            traits.DocumentReaders.Add(new BankDocumentReader());

            // DocumentWriter
            traits.DocumentWriters.Add(new SoundProjectDocumentWriter());
            traits.DocumentWriters.Add(new SoundSetDocumentWriterCommon());
            traits.DocumentWriters.Add(new BankDocumentWriter());

            return traits;
        }

        internal static SoundComponentTraits CreateSoundComponentTraits()
        {
            return null;
        }
    }
}
