﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundProjectConverter
{
    using System.Threading;
    using NintendoWare.SoundFoundation.Core.Threading;
    using NintendoWare.SoundFoundation.Utilities;

    /// <summary>
    /// プログラムのエントリポイントを含むクラスです。
    /// </summary>
    internal class Program
    {
        /// <summary>
        /// メイン関数です。
        /// </summary>
        /// <param name="args">コマンドライン引数を指定します。</param>
        /// <returns>プログラムの実行結果を返します。</returns>
        public static int Main(string[] args)
        {
            EnvironmentUtility.RemoveMultipleEnvironmentVariables();
            Thread.CurrentThread.InitializeCurrentUICulture();

            bool result = new ConsoleApplication().Run(args);
            return result ? 0 : 1;
        }
    }
}
