﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    public class ToolPageDictionary : IEnumerable<IToolWindowPage>, IEnumerable
    {
        private Dictionary<string, IToolWindowPage> _toolPages = new Dictionary<string, IToolWindowPage>();

        public IToolWindowPage this[string pageID]
        {
            get { return _toolPages[pageID]; }
        }

        public bool ContainsKey(string pageID)
        {
            if (null == pageID) { throw new ArgumentNullException("pageID"); }
            return _toolPages.ContainsKey(pageID);
        }

        public void Add(IToolWindowPage page)
        {
            if (null == page) { throw new ArgumentNullException("page"); }
            if (_toolPages.ContainsKey(page.PageID)) { return; }

            _toolPages.Add(page.PageID, page);
        }

        public IEnumerator<IToolWindowPage> GetEnumerator()
        {
            return _toolPages.Values.GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }
    }
}
