﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.Resources;

    public partial class HistoryListPanel : DockingPage, IToolWindowPage, ICommandTarget
    {
        public const string PageName = "HistoryList";

        public HistoryListPanel() : base(PageName)
        {
            InitializeComponent();

            Bitmap icon = ImageResource.BitmapIconHistoryWindow;
            icon.MakeTransparent(UIServiceBase.TransparentColor);

            Text = MessageResource.ToolWindowName_History;
            Image = icon;

            FloatingBounds = new Rectangle(-1, -1,
                                           Width + (SystemInformation.FrameBorderSize.Width * 2),
                                           Height + SystemInformation.CaptionHeight + SystemInformation.FrameBorderSize.Height);
        }

        public HistoryPanel HistoryPanel
        {
            get { return this.historyPanel; }
        }

        ICommandTarget ICommandTarget.FindTarget(Command command)
        {
            return null;
            //             return (this.historyPanel as ICommandTarget).FindTarget(command);
        }

        CommandStatus ICommandTarget.QueryStatus(Command command)
        {
            return CommandStatus.Unsupported;
            //             return (this.historyPanel as ICommandTarget).QueryStatus(command);
        }

        bool ICommandTarget.Execute(Command command)
        {
            return true;
        }
    }
}
