﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.IO;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;
    using NintendoWare.SoundFoundation.Core.IO;

    /// <summary>
    ///
    /// </summary>
    public partial class UserCommandPanel : UserControl
    {
        private string preservedLabelName = null;
        private string preservedLabelCommand = null;
        private int number = 0;
        private string cardinalFilePath = null;

        /// <summary>
        ///
        /// </summary>
        public UserCommandPanel()
        {
            InitializeComponent();

            this.preservedLabelName = this.lbl_CommandName.Text;
            this.preservedLabelCommand = this.lbl_Command.Text;
        }

        /// <summary>
        ///
        /// </summary>
        public int Number
        {
            get
            {
                return this.number;
            }
            set
            {
                this.number = value;
                this.lbl_CommandName.Text = String.Format(this.preservedLabelName, value);
                this.lbl_Command.Text = String.Format(this.preservedLabelCommand, value);
            }
        }

        /// <summary>
        ///
        /// </summary>
        public string CommandName
        {
            get
            {
                return this.tbx_CommandName.Text;
            }
            set
            {
                this.tbx_CommandName.Text = value;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public string Command
        {
            get
            {
                return this.tbx_Command.Text;
            }
            set
            {
                this.tbx_Command.Text = value;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public string IconFilePath
        {
            get
            {
                return this.tbx_IconFilePath.Text;
            }
            set
            {
                this.tbx_IconFilePath.Text = value;
            }
        }


        /// <summary>
        ///
        /// </summary>
        public string CardinalFilePath
        {
            get
            {
                return this.cardinalFilePath;
            }
            set
            {
                this.cardinalFilePath = value;
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void OnReferenceFilePath(object sender, EventArgs e)
        {
            OpenFileDialog dialog = new OpenFileDialog();
            dialog.FileName = Path.GetFileName(this.tbx_IconFilePath.Text);
            dialog.Filter = "All files (*.*)|*.*";

            string directory = null;
            if (this.tbx_IconFilePath.Text == String.Empty)
            {
                directory = this.cardinalFilePath;
            }
            else
            {
                string filePath = Path.GetFullPath
                    (Path.Combine(this.cardinalFilePath, this.tbx_IconFilePath.Text));
                directory = Path.GetDirectoryName(filePath);
            }
            dialog.InitialDirectory = directory;

            if (dialog.ShowDialog() != DialogResult.OK)
            {
                return;
            }

            string relativeFilePath = PathEx.MakeRelative(dialog.FileName, this.cardinalFilePath);
            this.tbx_IconFilePath.Text = relativeFilePath;
        }
    }
}
