﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.Text;
    using System.Windows.Forms;
    using System.IO;
    using SoundFoundation.Projects;
    using Framework.Resources;
    using Framework.Configurations;

    public partial class SoundListOutputSettingCreateDialog : Form
    {
        private string projectFilePath = null;

        public string OutputFilePath
        {
            get { return mOutputFilePathTextBox.Text; }
            set
            {
                mOutputFilePathTextBox.Text = value;
                UpdateOkButton();
            }
        }
        public string SettingName
        {
            get { return mSettingNameTextBox.Text; }
            set
            {
                mSettingNameTextBox.Text = value;
                UpdateOkButton();
            }
        }

        public SoundListOutputSettingCreateDialog(string projectFilePath)
        {
            InitializeComponent();

            this.projectFilePath = projectFilePath;

            UpdateOkButton();
        }

        private void UpdateOkButton()
        {
            bool enable = true;
            if (mOutputFilePathTextBox.Text == String.Empty)
            {
                enable = false;
            }
            if (mSettingNameTextBox.Text == String.Empty)
            {
                enable = false;
            }
            mOkButton.Enabled = enable;
        }

        public SoundListOutput NewSoundListOutput(string projectName)
        {
            SoundListOutput newSoundListOutput = new SoundListOutput()
            {
                Name = this.SettingName,
                Title = string.Format("{0} Project Sound List - {1}", projectName, this.SettingName),
                FilePath = this.OutputFilePath,
                IsIgnoreDisableItems = true,
            };

            ListOutput soundListOutput = this.CreateListOutput("Sounds", true);
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_ItemIndex, true));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_ItemType, true));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Name, true));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_PlayerReference, true));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_PlayerPriority, true));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment, true));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_ActorPlayer, false));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Volume, false));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment1, false));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment2, false));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment3, false));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment4, false));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment5, false));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment6, false));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment7, false));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment8, false));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment9, false));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_UserParameter0, false));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_UserParameter1, false));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_UserParameter2, false));
            soundListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_UserParameter3, false));

            ListOutput groupListOutput = this.CreateListOutput("Groups", true);
            groupListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_ItemIndex, true));
            groupListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Name, true));
            groupListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment, true));
            groupListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment1, false));
            groupListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment2, false));
            groupListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment3, false));
            groupListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment4, false));
            groupListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment5, false));
            groupListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment6, false));
            groupListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment7, false));
            groupListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment8, false));
            groupListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment9, false));

            ListOutput playerListOutput = this.CreateListOutput("Players", true);
            playerListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_ItemIndex, true));
            playerListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Name, true));
            playerListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_PlayerSoundLimit, true));
            playerListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment, true));
            playerListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment1, false));
            playerListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment2, false));
            playerListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment3, false));
            playerListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment4, false));
            playerListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment5, false));
            playerListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment6, false));
            playerListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment7, false));
            playerListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment8, false));
            playerListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment9, false));

            ListOutput soundSetBankListOutput = this.CreateListOutput("SoundSetBanks", false);
            soundSetBankListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_ItemIndex, true));
            soundSetBankListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Name, true));
            soundSetBankListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment, true));
            soundSetBankListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment1, false));
            soundSetBankListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment2, false));
            soundSetBankListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment3, false));
            soundSetBankListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment4, false));
            soundSetBankListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment5, false));
            soundSetBankListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment6, false));
            soundSetBankListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment7, false));
            soundSetBankListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment8, false));
            soundSetBankListOutput.ColumnOutputs.Add(this.CreateColumnOutput(ListTraits.ColumnName_Comment9, false));

            newSoundListOutput.ListOutputs.Add(soundListOutput);
            newSoundListOutput.ListOutputs.Add(groupListOutput);
            newSoundListOutput.ListOutputs.Add(playerListOutput);
            newSoundListOutput.ListOutputs.Add(soundSetBankListOutput);

            return newSoundListOutput;
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            // 結果コード別ハンドラ呼び出し
            if (this.DialogResult == DialogResult.OK)
            {
                if (HTMLSoundListPathValidator.Validate
                    (this.projectFilePath, OutputFilePath) == false)
                {
                    ApplicationBase.Instance.UIService.ShowMessageBox(MessageResource.Message_InvalidOutputFilePath);
                    e.Cancel = true;
                }
            }
            base.OnClosing(e);
        }

        private ListOutput CreateListOutput(string name, bool isOutput)
        {
            return new ListOutput()
            {
                Name = name,
                IsOutput = isOutput,
            };
        }

        private ListColumnOutput CreateColumnOutput(string name, bool isOutput)
        {
            return new ListColumnOutput()
            {
                Name = name,
                IsOutput = isOutput,
            };
        }

        private void button1_Click(object sender, EventArgs e)
        {
            string projectPath = Path.GetDirectoryName(this.projectFilePath);
            SaveFileDialog fileDialog = new SaveFileDialog();

            if (Path.IsPathRooted(mOutputFilePathTextBox.Text) == true)
            {
                try
                {
                    fileDialog.InitialDirectory = Path.GetDirectoryName(mOutputFilePathTextBox.Text);
                }
                catch
                {
                    fileDialog.InitialDirectory = projectPath;
                }
            }
            else
            {
                string fullPath = Path.Combine(projectPath, mOutputFilePathTextBox.Text);
                if (Directory.Exists(Path.GetDirectoryName(fullPath)) == true)
                {
                    fileDialog.InitialDirectory = Path.GetDirectoryName(fullPath);
                }
                else
                {
                    fileDialog.InitialDirectory = projectPath;
                }
            }
            fileDialog.FileName = Path.GetFileName(mOutputFilePathTextBox.Text);
            fileDialog.Filter = "HTML files (*.html;*.htm)|*.html;*.htm|All files (*.*)|*.*";
            fileDialog.DefaultExt = "html";
            fileDialog.OverwritePrompt = false;
            fileDialog.Title = MessageResource.DialogTitle_OutputFilePath;

            if (fileDialog.ShowDialog(this) == DialogResult.OK)
            {
                if (fileDialog.FileName.Contains(projectPath) == true)
                {
                    mOutputFilePathTextBox.Text = fileDialog.FileName.Substring(projectPath.Length + 1, fileDialog.FileName.Length - (projectPath.Length + 1));
                }
                else
                {
                    mOutputFilePathTextBox.Text = fileDialog.FileName;
                }

                UpdateOkButton();
            }
        }

        private void mOutputFilePathTextBox_TextChanged(object sender, EventArgs e)
        {
            UpdateOkButton();
        }

        private void mSettingNameTextBox_TextChanged(object sender, EventArgs e)
        {
            UpdateOkButton();
        }
    }
}
