﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Linq;
    using System.Windows.Forms;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.CommandHandlers;

    public partial class PasteColumnChooseDialog : Form
    {
        ///
        private class Item
        {
            public string Text { get; set; }
            public string Name { get; set; }

            public Item(string name, string text)
            {
                Name = name;
                Text = text;
            }

            public override string ToString()
            {
                return Text;
            }
        }

        ///--------------------------------
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public PasteColumnChooseDialog()
        {
            InitializeComponent();
        }

        ///--------------------------------
        /// <summary>
        /// コンストラクタ
        /// </summary>
        //public PasteColumnChooseDialog( ComponentHeaderAdapter adapter)
        public PasteColumnChooseDialog(ClipboardService.HeaderItem[] headerItems)
        {
            InitializeComponent();

            foreach (ClipboardService.HeaderItem headerItem in headerItems)
            {
                Item item = new Item(headerItem.Name, headerItem.Text);
                checkedListBox.Items.Add(item, headerItem.Checked);
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public string[] CheckedNames
        {
            get
            {
                return checkedListBox.CheckedItems
                    .Cast<Item>().Select(i => i.Name).ToArray();
            }
        }
    }
}
