﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    ///--------------------------------------------------------------------------
    /// <summary>
    /// ProjectCreateWizard の概要の説明です。
    /// </summary>
    public partial class ProjectCreateWizard : Form
    {
        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private Hashtable _Pages = new Hashtable();
        private Control _CurrentPage = null;
        private IWizardPage _CurrentPageInterface = null;
        private List<string> _PageHistory = new List<string>();

        ///--------------------------------
        private ProjectCreatePageName _PageName = null;
        private ProjectCreatePageSpecifySoundSet _PageSpecifySoundSet = null;
        private ProjectCreatePageFinish _PageFinish = null;

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ProjectCreateWizard()
        {
            InitializeComponent();

            button_Finish.Location = button_Next.Location;
            button_Finish.Size = button_Next.Size;

            //
            _PageName = new ProjectCreatePageName();
            _PageSpecifySoundSet = new ProjectCreatePageSpecifySoundSet();
            _PageFinish = new ProjectCreatePageFinish();

            AppendPage("Name", _PageName);
            AppendPage("SpecifySoundSet", _PageSpecifySoundSet);
            AppendPage("Finish", _PageFinish);

            NextPage("Name");
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public void ShowFinishButton()
        {
            button_Finish.Enabled = true;
            button_Finish.Visible = true;
            button_Next.Enabled = false;
            button_Next.Visible = false;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public void HideFinishButton()
        {
            button_Finish.Enabled = false;
            button_Finish.Visible = false;
            button_Next.Enabled = true;
            button_Next.Visible = true;
        }

        ///--------------------------------
        /// <summary>
        /// ページの追加
        /// </summary>
        public bool AppendPage(string name, Control control)
        {
            _Pages.Add(name, control);
            return true;
        }

        ///--------------------------------
        /// <summary>
        /// 指定ページの表示
        /// </summary>
        public bool ShowPage(string name)
        {
            Control pageControl = null;
            IWizardPage pageInterface = null;

            if ((pageControl = _Pages[name] as Control) == null ||
                 (pageInterface = _Pages[name] as IWizardPage) == null)
            {
                return false;
            }

            if (_CurrentPage != null)
            {
                _CurrentPage.Hide();
            }

            if (pageInterface.QueryFinishPage() != false)
            {
                ShowFinishButton();
            }
            else
            {
                HideFinishButton();
            }

            _CurrentPage = pageControl;
            _CurrentPage.Parent = panel_View;
            _CurrentPage.Show();

            //
            if (pageInterface.OnBack() != false)
            {
                button_Prev.Enabled = true;
            }
            else
            {
                button_Prev.Enabled = false;
            }

            _CurrentPageInterface = pageInterface;
            return true;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public void NextPage(string name)
        {
            if (ShowPage(name) != false)
            {
                _PageHistory.Add(name);
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public void BackPage()
        {
            if (_PageHistory.Count <= 1)
            {
                return;
            }

            string name = null;

            name = _PageHistory[_PageHistory.Count - 2];
            if (ShowPage(name) != false)
            {
                _PageHistory.RemoveAt(_PageHistory.Count - 1);
            }
        }


        ///--------------------------------
        /// <summary>
        /// サウンドセットを作成するのか？
        /// </summary>
        public bool DoCreateSoundSet
        {
            get { return _PageName.DoCreateSoundSet; }
        }

        ///--------------------------------
        /// <summary>
        /// サウンドセットを指定するのか？
        /// </summary>
        public bool DoSpecifySoundSet
        {
            get { return _PageName.DoSpecifySoundSet; }
        }

        ///--------------------------------
        /// <summary>
        /// サウンドセットのパスの取得
        /// </summary>
        public string SoundSetFilePath
        {
            get
            {
                if (DoCreateSoundSet != false)
                {
                    return _PageName.SoundSetFilePath;
                }
                if (DoSpecifySoundSet != false)
                {
                    return _PageSpecifySoundSet.SoundSetFilePath;
                }
                return null;
            }
        }

        ///--------------------------------
        /// <summary>
        /// プロジェクトファイルのパスの取得
        /// </summary>
        public string ProjectFilePath
        {
            get { return _PageName.ProjectFilePath; }
        }

        // <summary>
        // 古いバージョンのファイル群の取得
        // </summary>
        public string[] OldVersionFilePaths
        {
            get
            {
                if (DoSpecifySoundSet == true)
                {
                    return _PageSpecifySoundSet.OldVersionFilePaths;
                }

                return null;
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnNext(object sender, System.EventArgs e)
        {
            string name = null;

            if (_CurrentPageInterface != null)
            {
                if ((name = _CurrentPageInterface.OnNext()) != null)
                {
                    NextPage(name);
                }
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnBack(object sender, System.EventArgs e)
        {
            if (_CurrentPageInterface != null)
            {
                if (_CurrentPageInterface.OnBack() != false)
                {
                    BackPage();
                }
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnFinish(object sender, System.EventArgs e)
        {
            if (_CurrentPageInterface != null)
            {
                if ((_CurrentPageInterface.OnFinish()) != false)
                {
                    DialogResult = DialogResult.OK;
                    Close();
                }
            }
        }
    }
}
