﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Core;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.Resources;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    public partial class CreateSoundSetItemDialog : CreateProjectItemDialog
    {
        protected CreateSoundSetItemDialog()
        {
            InitializeComponent();
        }

        protected CreateSoundSetItemDialog(SoundProjectService projectService) : base(projectService)
        {
            InitializeComponent();
        }

        /// <summary>
        /// ファイルパスから名前を作成します。
        /// </summary>
        /// <param name="filePath">ファイルパス。</param>
        /// <returns>アイテムの名前。</returns>
        protected string CreateSoundSetItemNameFromFilePath(string prefix, string filePath)
        {
            if (null == prefix) { throw new ArgumentNullException("prefix"); }
            if (null == filePath) { throw new ArgumentNullException("filePath"); }

            return ItemNamer.CreateUniqueNameFromFileName(
                                    ProjectService.ComponentDictionary,
                                    new ItemNamingSettings(ProjectService.Project),
                                    prefix, string.Empty, filePath);
        }
    }
}
