﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;

    public partial class ProgressDialog : Form
    {
        private BackgroundWorker worker;

        public event DoWorkEventHandler DoWork;
        public event ProgressChangedEventHandler ProgressChanged;
        public event RunWorkerCompletedEventHandler RunWorkerCompleted;

        public ProgressDialog()
            : this(false)
        {
        }

        // cancel 関係は未実装：デフォルト
        public ProgressDialog(bool cancel)
        {
            InitializeComponent();
            this.button_Cancel.Enabled = cancel;
            this.button_Cancel.Visible = cancel;
            this.worker = new BackgroundWorker();
            this.worker.DoWork += OnDoWork;
            this.worker.ProgressChanged += OnProgressChanged;
            this.worker.RunWorkerCompleted += OnRunWorkerCompleted;
        }

        public new DialogResult ShowDialog()
        {
            this.worker.RunWorkerAsync();
            return base.ShowDialog();
        }

        public string Title
        {
            get
            {
                return this.Text;
            }

            set
            {
                this.Text = value;
            }
        }

        public string Message
        {
            get
            {
                return this.label_Message.Text;
            }

            set
            {
                this.label_Message.Text = value;
            }
        }

        public ProgressBarStyle Style
        {
            get
            {
                return this.progressBar1.Style;
            }

            set
            {
                this.progressBar1.Style = value;
            }
        }

        public int Value
        {
            get
            {
                return this.progressBar1.Value;
            }

            set
            {
                this.progressBar1.Value = value;
            }
        }

        public int Minimum
        {
            get
            {
                return this.progressBar1.Minimum;
            }

            set
            {
                this.progressBar1.Minimum = value;
            }
        }

        public int Maximum
        {
            get
            {
                return this.progressBar1.Maximum;
            }

            set
            {
                this.progressBar1.Maximum = value;
            }
        }

        private void OnDoWork(object sender, DoWorkEventArgs e)
        {
            if (this.DoWork != null)
            {
                this.DoWork(sender, e);
            }
        }

        private void OnProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            if (this.ProgressChanged != null)
            {
                this.ProgressChanged(sender, e);
            }
        }

        private void OnRunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            if (this.RunWorkerCompleted != null)
            {
                this.RunWorkerCompleted(sender, e);
            }
        }
    }
}
