﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using NintendoWare.SoundMaker.Framework.Resources;

    /// <summary>
    ///
    /// </summary>
    public partial class MeasureDialog : Form
    {
        private static int DefaultMeasureTime = 10;

        /// <summary>
        ///
        /// </summary>
        public MeasureDialog()
        {
            InitializeComponent();

            this.MeasureTime = DefaultMeasureTime;
        }

        /// <summary>
        ///
        /// </summary>
        public int MeasureTime
        {
            get
            {
                return int.Parse(this.tbx_MeasureTime.Text);
            }
            set
            {
                this.tbx_MeasureTime.Text = value.ToString();
            }
        }

        /// <summary>
        ///
        /// </summary>
        protected override void OnClosed(EventArgs e)
        {
            if (DialogResult == DialogResult.OK)
            {
                DefaultMeasureTime = MeasureTime;
            }

            base.OnClosed(e);
        }

        /// <summary>
        ///
        /// </summary>
        private void ValidateMeasureTime()
        {
            int value = 0;
            string text = null;
            bool validate = int.TryParse(this.tbx_MeasureTime.Text, out value);

            if (validate == true)
            {
                if (value < 0)
                {
                    text = MessageResource.Message_OutsideValueRange;
                    validate = false;
                }
            }
            else
            {
                text = MessageResource.Message_PleaseInputNumericalValue;
            }

            this.errorProvider.SetError(this.tbx_MeasureTime, text);
            this.btn_Execute.Enabled = validate;
        }

        /// <summary>
        ///
        /// </summary>
        private void OnTextChanged_MeasureTime(object sender, EventArgs e)
        {
            ValidateMeasureTime();
        }
    }
}
