﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NintendoWare.SoundFoundation.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    public class DockingToolContainerDictionary : IEnumerable<DockingToolContainer>, IEnumerable
    {
        private Dictionary<string, DockingToolContainer> _containers = new Dictionary<string, DockingToolContainer>();

        public DockingToolContainer this[string containerID]
        {
            get { return _containers[containerID]; }
        }

        public bool ContainsKey(string containerID)
        {
            if (null == containerID) { throw new ArgumentNullException("containerID"); }
            return _containers.ContainsKey(containerID);
        }

        public void Add(string containerID, DockingToolContainer container)
        {
            if (null == containerID) { throw new ArgumentNullException("containerID"); }
            if (null == container) { throw new ArgumentNullException("container"); }
            if (_containers.ContainsKey(containerID)) { return; }

            _containers.Add(containerID, container);
        }

        public IEnumerator<DockingToolContainer> GetEnumerator()
        {
            return _containers.Values.GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }
    }
}
