﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.Drawing;
    using System.Text;
    using SoundFoundation.Logs;
    using SoundFoundation.Windows.Forms;

    public class ConvertLogTextBox : NLogTextBox
    {
        #region ** メソッド

        // 本気で選択処理を実装するのが大変なので、暫定対処
        public void SelectLastItem()
        {
            if (0 == Blocks.Count) { return; }
            SelectBlock(Blocks.Last, false);
        }

        protected override NLogTextBox.IBlockDrawer GetDrawer(NLogTextBox.Block block)
        {
            if (block.UserData is ErrorLine)
            {
                return new ErrorLogDrawer();
            }
            else if (block.UserData is WarningLine)
            {
                return new WarningLogDrawer();
            }

            return base.GetDrawer(block);
        }

        #endregion

        #region ** 描画クラス

        protected class ErrorLogDrawer : DefaultBlockDrawer
        {
            public override void Draw(Block block, Graphics g, Font font, Brush textBrush, Brush backBrush, Rectangle rect, StringFormat format)
            {
                if (block.Selected)
                {
                    base.Draw(block, g, font, Brushes.White, Brushes.Red, rect, format);
                }
                else
                {
                    base.Draw(block, g, font, Brushes.Red, backBrush, rect, format);
                }
            }
        }

        protected class WarningLogDrawer : DefaultBlockDrawer
        {
            public override void Draw(Block block, Graphics g, Font font, Brush textBrush, Brush backBrush, Rectangle rect, StringFormat format)
            {
                if (block.Selected)
                {
                    base.Draw(block, g, font, Brushes.White, Brushes.Blue, rect, format);
                }
                else
                {
                    base.Draw(block, g, font, Brushes.Blue, backBrush, rect, format);
                }
            }
        }

        #endregion
    }
}
