﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using NintendoWare.SoundFoundation.Operations;
    using NintendoWare.SoundFoundation.Parameters;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.Preset;
    using NintendoWare.SoundMaker.Framework.Resources;

    public partial class BookmarkCtrl : TreeCtrl
    {
        public BookmarkCtrl()
        {
            InitializeComponent();

            Images.Add("IconStreamSoundPack", ImageResource.BitmapIconStreamSoundFolder);
            Images.Add("IconWaveSoundSetPack", ImageResource.BitmapIconWaveSoundSetFolder);
            Images.Add("IconWaveSoundSet", ImageResource.BitmapIconWaveSoundSet);
            Images.Add("IconSequenceSoundPack", ImageResource.BitmapIconSequenceSoundFolder);
            Images.Add("IconSequenceSoundSetPack", ImageResource.BitmapIconSequenceSoundSetFolder);
            Images.Add("IconSequenceSoundSet", ImageResource.BitmapIconSequenceSoundSet);
            Images.Add("IconBankPack", ImageResource.BitmapIconBankFolder);
            Images.Add("IconBank", ImageResource.BitmapIconBank);
            Images.Add("IconWaveArchivePack", ImageResource.BitmapIconWaveArchiveFolder);
            Images.Add("IconGroupPack", ImageResource.BitmapIconGroupFolder);
            Images.Add("IconPlayerPack", ImageResource.BitmapIconPlayerFolder);
            Images.Add("IconBookmarkFolder", ImageResource.BitmapIconBookmarkFolder);
            Images.Add("IconBookmarkFind", ImageResource.BitmapIconLoupe);
            Images.Add("IconError", ImageResource.BitmapIconItemError);
        }

        public override TreeDoubleClickedAction OnDoubleClicked(ITreeItem origItem, string name)
        {
            BookmarkTreeItem item = origItem as BookmarkTreeItem;

            if (item.Target is BookmarkFolder == true)
            {
                if (FormsApplication.Instance.BookmarkService.BookmarkRoot == item.Target)
                {
                    return TreeDoubleClickedAction.None;
                }

                return TreeDoubleClickedAction.ToggleExpand;
            }
            else if (item.Target is Bookmark == true)
            {
                Bookmark bookmark = item.Target as Bookmark;
                SoundSet soundSet = bookmark.SoundSet;

                if (bookmark.ValidateTarget() == false)
                {
                    return TreeDoubleClickedAction.None;
                }
                if (bookmark.Target is SoundSetBankBase)
                {
                    SoundSetBankBase bank = bookmark.Target as SoundSetBankBase;

                    string filePath = new ReferenceFileFinder()
                    {
                        Text = bank.FilePath,
                    }.Validate(bank.FilePath);

                    if (null == filePath) { return TreeDoubleClickedAction.None; }

                    CommonTabPage page0 = FormsApplication.Instance.UIService.MainWindow.ActivePage;
                    FormsApplication.Instance.UIService.MainWindow.OpenFile(bank);
                    CommonTabPage page1 = FormsApplication.Instance.UIService.MainWindow.ActivePage;
                    if (page0 == page1)
                    {
                        FormsApplication.Instance.UIService.MainWindow.HistoryAdd(bookmark.Target, true);
                    }
                }
                else if (soundSet != null)
                {
                    CommonTabPage page0 = FormsApplication.Instance.UIService.MainWindow.ActivePage;
                    CommonTabPage page = FormsApplication.Instance.UIService.MainWindow.AddPage(soundSet);
                    SoundSetPanel soundSetPanel = page.Panel as SoundSetPanel;

                    SoundSetItem soundSetItem = bookmark.Target as SoundSetItem;
                    soundSetPanel.Show(soundSetItem);
                    soundSetPanel.ActivatePanel(true, true);
                    CommonTabPage page1 = FormsApplication.Instance.UIService.MainWindow.ActivePage;
                    bool forceAdd = (page0 == null || page0 == page1);
                    FormsApplication.Instance.UIService.MainWindow.HistoryAdd(bookmark.Target, forceAdd);
                }
            }
            else if (item.Target is BookmarkFind == true)
            {
                BookmarkFind bookmark = item.Target as BookmarkFind;

                FormsApplication.Instance.UIService.MainWindow.AddFindTabPage
                    ((bookmark.FindKind == "SoundSet" ?
                      FindArgs.TargetDocumentKinds.SoundSet :
                      FindArgs.TargetDocumentKinds.Bank),
                      delegate (FindResultPanel2 panel)
                          {
                              panel.TitleName = bookmark.Name;
                              panel.Keyword = bookmark.FindKeyword;
                              panel.SetTargetParameterNames(bookmark.FindParameters);
                              panel.SetTargetSoundSetNames(bookmark.FindSoundSets);
                              panel.SetTargetFilterNames(bookmark.FindFilters);
                              panel.Find();
                          });
            }

            return TreeDoubleClickedAction.None;
        }

        public virtual BookmarkComponent[] GetComponentsBySelectedItem()
        {
            return SelectedItems.Cast<ComponentTreeItem>().Select(i => i.Target).Cast<BookmarkComponent>().ToArray();
        }
    }
}
