﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms.CommandHandlers
{
    using System;
    using System.IO;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.CommandHandlers;
    using CoreResources = NintendoWare.SoundFoundation.Resources;

    /// <summary>
    /// ファイルパスを問い合わせてプロジェクトを開きます。
    /// </summary>
    public class QueryAndImportSoundSetHandler : ImportSoundSetHandler
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="queryTarget">対象の問い合わせ先。</param>
        public QueryAndImportSoundSetHandler(IQueryCommandParameter queryParameter)
            : base(queryParameter)
        {
        }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        /// <returns>実行した場合は true、実行しなかった、キャンセルした場合は false。</returns>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            if (null == parameters)
            {
                throw new ArgumentNullException("parameters");
            }

            SoundProjectService projectService = GetTargetProjectService(parameters);
            if (null == projectService) { return false; }

            string filePath = null;

            if (null == filePath)
            {
                filePath = AnotherPlatformSoundSetFileQuester.QueryLoad();
            }
            if (null == filePath)
            {
                return false;
            }

            try
            {
                if (base.ExecuteInternal(projectService, filePath))
                {
                    return true;
                }
            }
            catch (DirectoryNotFoundException)
            {
                string message =
                    string.Format(
                                  Resources.MessageResource.Message_TargetFileNotFound,
                                  filePath
                                  );
                ApplicationBase.Instance.UIService.ShowMessageBox(message);

                return false;
            }
            catch (FileNotFoundException exception)
            {
                if (exception.FileName != filePath)
                {
                    string message =
                        string.Format(
                                      Resources.MessageResource.Message_TargetFileNotFound,
                                      exception.FileName
                                      );
                    ApplicationBase.Instance.UIService.ShowMessageBox(message);

                    return false;
                }

            }
            catch (FileNotSupportedException exception)
            {
                string message = string.Format("{0}\n{1}",
                                               exception.Message,
                                               exception.FilePath);
                ApplicationBase.Instance.UIService.ShowMessageBox(message);

                return false;
            }
            catch
            {
                string message = Resources.MessageResource.Message_UnknownError;
                ApplicationBase.Instance.UIService.ShowMessageBox(message);

                return false;
            }

            return true;
        }
    }
}
