﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms.CommandHandlers
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using NintendoWare.SoundFoundation.CommandHandlers;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.CommandHandlers;
    using NintendoWare.SoundMaker.Framework.Commands;

    public class OpenBankItemHandler : CommandHandler
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public OpenBankItemHandler(IQueryCommandParameter queryParameter)
            : base(queryParameter)
        {
        }

        /// <summary>
        ///
        /// </summary>
        public override string TargetCommandID
        {
            get { return FileCommands.OpenBankItem.ID; }
        }

        /// <summary>
        /// コマンドを実行できるかどうか調べる
        /// </summary>
        protected override CommandStatus QueryStatusInternal(Command command, IQueryCommandParameter parameters)
        {
            Component[] components = GetTargetComponents(parameters);

            if (components.Length != 1)
            {
                return CommandStatus.SupportedAndVisible;
            }

            if (components[0] is SequenceSoundBase == true)
            {
                SequenceSoundBase sequenceSound = components[0] as SequenceSoundBase;
                int soundSetBankCount = sequenceSound.SoundSetBanks
                    .Count(s => s != null);
                if (soundSetBankCount == 1)
                {
                    return CommandStatus.SupportedAndEnabledAndVisible;
                }
            }

            return CommandStatus.SupportedAndVisible;
        }

        /// <summary>
        /// コマンドの実行
        /// </summary>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            Component[] components = GetTargetComponents(parameters);

            SequenceSoundBase sequenceSound = components[0] as SequenceSoundBase;
            SoundSetBankBase soundSetBank = sequenceSound.SoundSetBanks
                .Where(s => s != null)
                .FirstOrDefault();
            if (soundSetBank != null)
            {
                FormsApplication.Instance.UIService.MainWindow.OpenFile(soundSetBank);
            }

            return true;
        }

        /// <summary>
        ///
        /// </summary>
        private Component[] GetTargetComponents(IQueryCommandParameter parameters)
        {
            if (null == parameters) { throw new ArgumentNullException("parameters"); }

            if (parameters.ContainsParameter(CommandParameterNames.TargetComponents) == false)
            {
                return null;
            }

            return (parameters.GetParameter(CommandParameterNames.TargetComponents)
                    as IEnumerable<Component>).ToArray();
        }
    }
}
