﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Framework.Resources
{
    using System.IO;
    using System.Text;

    internal class FileResourcesProxy
    {
        internal static string AppConfigurationToolPagesDefault
        {
            get { return GetUtf8String("AppConfigurationToolPagesDefault"); }
        }

        internal static string AppConfigurationWindowsDefault
        {
            get { return GetUtf8String("AppConfigurationWindowsDefault"); }
        }

        internal static string OptionConfigurationDefault
        {
            get { return GetUtf8String("OptionConfigurationDefault"); }
        }

        internal static string SchemaAppConfiguration
        {
            get { return GetUtf8String("SchemaAppConfiguration"); }
        }

        internal static string SchemaOptionConfiguration
        {
            get { return GetUtf8String("SchemaOptionConfiguration"); }
        }

        internal static string SchemaSoundProjectConfiguration
        {
            get { return GetUtf8String("SchemaSoundProjectConfiguration"); }
        }

        internal static string SchemaUriConfiguration
        {
            get { return GetUtf8String("SchemaUriConfiguration"); }
        }

        internal static string SchemaWindowConfiguration
        {
            get { return GetUtf8String("SchemaWindowConfiguration"); }
        }

        internal static string SoundProjectConfigurationBankDocumentViewDefault
        {
            get { return GetUtf8String("SoundProjectConfigurationBankDocumentViewDefault"); }
        }

        internal static string SoundProjectConfigurationConvertDefault
        {
            get { return GetUtf8String("SoundProjectConfigurationConvertDefault"); }
        }

        internal static string SoundProjectConfigurationDefault
        {
            get { return GetUtf8String("SoundProjectConfigurationDefault"); }
        }

        internal static string SoundProjectConfigurationListsDefault
        {
            get { return GetUtf8String("SoundProjectConfigurationListsDefault"); }
        }

        internal static string SoundProjectConfigurationMainWindowDefault
        {
            get { return GetUtf8String("SoundProjectConfigurationMainWindowDefault"); }
        }

        internal static string SoundProjectConfigurationOutputDefault
        {
            get { return GetUtf8String("SoundProjectConfigurationOutputDefault"); }
        }

        internal static string SoundProjectConfigurationSoundProjectDocumentViewDefault
        {
            get { return GetUtf8String("SoundProjectConfigurationSoundProjectDocumentViewDefault"); }
        }

        internal static string SoundProjectConfigurationSoundSetDocumentViewDefault
        {
            get { return GetUtf8String("SoundProjectConfigurationSoundSetDocumentViewDefault"); }
        }

        private static string GetUtf8String(string resourceName)
        {
            using (var reader = new StreamReader(
                new MemoryStream((byte[])FileResources.ResourceManager.GetObject(resourceName, FileResources.Culture)),
                Encoding.UTF8))
            {
                return reader.ReadToEnd();
            }
        }
    }
}
