﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

namespace NintendoWare.SoundMaker.Framework.Preview.Communications.Error
{
    using NW4R.ProtocolSound;

    #region ** エラーパケットの基本クラス

    #region ** イベント

    public delegate void ErrorPacketRecievedEventHandler(object sender, ErrorPacketRecievedEventArgs e);

    public class ErrorPacketRecievedEventArgs : EventArgs
    {
        #region ** パラメータ

        private SoundErrorPacket _packet;

        #endregion

        public ErrorPacketRecievedEventArgs(SoundErrorPacket packet)
        {
            _packet = packet;
        }

        #region ** プロパティ

        public SoundErrorPacket ErrorPacket
        {
            get { return _packet; }
        }

        #endregion
    }

    #endregion

    /// <summary>
    /// サウンドエラーパケットの基本クラス
    /// </summary>
    public class SoundErrorPacket : ErrorPacket
    {
        #region ** パラメータ

        private SoundError _errorInfo;

        #endregion

        /// <summary>
        /// コンストラクタ
        /// </summary>
        protected SoundErrorPacket(CommPacket target) : base(target)
        {
            Debug.Assert(Constants.CATEGORY_SOUND == Category, "Category is not sound");

            _errorInfo = new SoundError();
            _errorInfo.errorCode = Constants.SOUND_S_OK;
        }

        #region ** イベント

        public static event ErrorPacketRecievedEventHandler PacketRecieved;

        #endregion

        #region ** プロパティ

        public SoundError ErrorInfo
        {
            get { return _errorInfo; }
        }

        #endregion

        #region ** プロパティのオーバーライド

        /// <summary>
        /// パケットの種類
        /// </summary>
        public override ushort PacketType
        {
            get { return Constants.ERR_SOUND; }
        }

        #endregion

        #region ** メソッド

        /// <summary>
        /// サウンドエラーパケットを作成します。
        /// </summary>
        public static SoundErrorPacket CreatePacket(uint packetType, CommPacket target)
        {
            return new SoundErrorPacket(target);
        }

        #endregion

        #region ** メソッドのオーバーライド

        /// <summary>
        /// ストリームからデータを読み込みます。
        /// </summary>
        /// <param name="reader">対象ストリーム</param>
        /// <param name="header">パケットヘッダ</param>
        public override void Read(ProtocolSoundReader reader, CommPacketHeader header)
        {
            _errorInfo.Read(reader);

            if (null != PacketRecieved)
            {
                PacketRecieved(this, new ErrorPacketRecievedEventArgs(this));
            }
        }

        #endregion
    }

    #endregion
}
