﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.FileFormats
{
    using System.IO;
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary;
    using SoundFoundation.Core.IO;
    using ToolDevelopmentKit;

    /// <summary>
    /// シーケンスサウンドバイナリを解析します。
    /// </summary>
    public class SequenceSoundBinaryParser : SequenceSoundFileParser
    {
        /// <summary>
        /// ファイルを解析します。
        /// </summary>
        /// <param name="filePath">ファイルパスを指定します。</param>
        protected override void ParseInternal(string filePath)
        {
            Ensure.Argument.NotNull(filePath);
            Ensure.Argument.StringNotEmpty(filePath);

            if (File.Exists(filePath) == true)
            {
                using (FileStream stream =
                       File.Open(filePath, FileMode.Open, FileAccess.Read, FileShare.Read))
                {
                    ISequenceSoundBinaryReader reader = ApplicationBase.Instance.Traits.ConversionTraits.SequenceSoundBinaryReader;

                    reader.Parse(
                                 this.IsLittleEndian ?
                                 LittleEndianBinaryReader.Create(stream) :
                                 BigEndianBinaryReader.Create(stream));

                    foreach (LabelInfo labelInfo in reader.LabelInfos)
                    {
                        this.Labels.Add(
                                        new Label()
                                        {
                                            Name = labelInfo.Label,
                                            Address = labelInfo.Address,
                                            OffsetFromDataBlockBody = labelInfo.OffsetFromDataBlockBody,
                                        });
                    }

                    this.AddDependentFileTimes(filePath);
                }
            }
        }

        private void AddDependentFileTimes(string filePath)
        {
            Assertion.Argument.NotNull(filePath);
            Assertion.Argument.StringNotEmpty(filePath);

            this.DependentFileTimes[filePath] = File.GetLastWriteTime(filePath);
        }
    }
}
