﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Framework.FileFormats
{
    public static class AACUtil
    {
        /// <summary>
        /// AACファイルなのか調べます。
        /// </summary>
        public static bool IsAACFile(string filePath)
        {
            if (AppConfiguration.EnabledAAC == false)
            {
                return false; // 無効の場合は常に false。AAC ファイルかどうかの判断自体無効にします。
            }

            return IsAACFilePrimitive(filePath);
        }

        /// <summary>
        /// AACファイルなのか調べます。（EnabledAAC フラグに影響しない）
        /// </summary>
        public static bool IsAACFilePrimitive(string filePath)
        {
            /// 現状では拡張子だけで判断します。
            return string.Compare(Path.GetExtension(filePath), AppConfiguration.AACFileExtension, ignoreCase: true) == 0;
        }
    }
}
