﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using NintendoWare.SoundFoundation.Projects;

    internal static class SequenceSoundBaseEx
    {
        /// <summary>
        /// 全てのサウンドセットバンクのリンクが結ばれているのか調べます。
        /// </summary>
        public static bool IsLinkedAllSoundSetBank(this SequenceSoundBase sequenceSound)
        {
            for (int index = 0; index < sequenceSound.SoundSetBanks.Count; index++)
            {
                if (sequenceSound.IsLinkedSoundSetBank(index) == false)
                {
                    return false;
                }
            }
            return true;
        }

        /// <summary>
        /// 指定インデックスのサウンドセットバンクのリンクが結ばれているのか調べます。
        /// </summary>
        public static bool IsLinkedSoundSetBank(this SequenceSoundBase sequenceSound, int index)
        {
            if (sequenceSound.SoundSetBankReferences[index].TargetName == String.Empty)
            {
                return true;
            }

            return sequenceSound.SoundSetBanks[index] != null ? true : false;
        }
    }
}
