﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    /// <summary>
    /// 全てのウィンドウ設定を格納します。
    /// </summary>
    public partial class XmlWindows
    {
        /// <summary>
        /// XmlWindows に含まれる全 XmlWindow の一覧を取得します。
        /// </summary>
        /// <returns>全 XmlWindow が含まれたディクショナリ。</returns>
        public IDictionary<string, XmlWindow> CreateDictionary()
        {
            Dictionary<string, XmlWindow> result = new Dictionary<string, XmlWindow>();

            foreach (XmlWindow xmlWindow in Items)
            {
                result.Add(xmlWindow.Name, xmlWindow);
            }

            return result;
        }
    }
}
