﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using NintendoWare.SoundMaker.Framework.Configurations;

    public partial class XmlSoundSetDocumentView
    {
        public static readonly string[] ListNames = new string[] {
                                                        ListTraits.ListName_StreamSound,
                                                        ListTraits.ListName_StreamSoundTrack,
                                                        ListTraits.ListName_WaveSoundSet,
                                                        ListTraits.ListName_WaveSoundSetItem,
                                                        ListTraits.ListName_SequenceSoundSet,
                                                        ListTraits.ListName_SequenceSoundSetItem,
                                                        ListTraits.ListName_SequenceSound,
                                                        ListTraits.ListName_Bank,
                                                        ListTraits.ListName_WaveArchive,
                                                        ListTraits.ListName_Player,
                                                        ListTraits.ListName_Group,
                                                        ListTraits.ListName_GroupItem,
                                                        ListTraits.ListName_MultipleBank,
                                                    };

        public static XmlSoundSetDocumentView CreateInstance(string filePath)
        {
            return new XmlSoundSetDocumentView()
            {
                FilePath = filePath,
                StreamSoundTrackListView = new Schemas.XmlSoundSetDocumentViewStreamSoundTrackListView(),
                WaveSoundSetListView = new Schemas.XmlSoundSetDocumentViewWaveSoundSetListView(),
                SequenceSoundSetListView = new Schemas.XmlSoundSetDocumentViewSequenceSoundSetListView(),
                GroupListView = new Schemas.XmlSoundSetDocumentViewGroupListView(),
                Lists = new XmlLists()
                {
                    List = new XmlList[0],
                },
            };
        }

        public override bool Validate()
        {
            return Validate(Lists.ExportDictionary());
        }

        public bool Validate(IDictionary<string, XmlList> xmlLists)
        {
            if (null == xmlLists) { throw new ArgumentNullException("xmlLists"); }

            if (null == Lists) { return false; }
            if (null == Lists.List) { return false; }

            foreach (string listName in ListNames)
            {
                if (!xmlLists.ContainsKey(listName)) { return false; }
            }

            return true;
        }
    }
}
