﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Commands
{
    using System.Collections.Generic;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Core.Reflection;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.SoundMaker.Framework.Windows;

    /// <summary>
    /// ウィンドウ関連コマンドを管理します。
    /// </summary>
    public static class WindowCommands
    {
        /// <summary>
        /// ウィンドウ関連コマンドを列挙する IEnumerable を取得します。
        /// </summary>
        public static IEnumerable<Command> Commands
        {
            get
            {
                return ObjectFinder.FindStaticValues<Command>(typeof(WindowCommands),
                                                               BindingFlags.GetProperty | BindingFlags.GetField);
            }
        }

        /// <summary>
        /// 上下に分割。
        /// </summary>
        public static readonly Command SplitEditHorizontal =
            new Command("Window.SplitEditHorizontal", MessageResource.Command_Window_SplitEditHorizontal_Name)
            {
#if false
                Text = MessageResource.Command_Window_SplitEditHorizontal_Text,
#endif
                Image = ImageResource.BitmapIconSplitEditHorizontal.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// 左右に分割。
        /// </summary>
        public static readonly Command SplitEditVertical =
            new Command("Window.SplitEditVertical", MessageResource.Command_Window_SplitEditVertical_Name)
            {
#if false
                Text = MessageResource.Command_Window_SplitEditVertical_Text,
#endif
                Image = ImageResource.BitmapIconSplitEditVertical.MakeNewTransparent(UIServiceBase.TransparentColor),
            };
    }
}
