﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Commands
{
    using System.Collections.Generic;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Core.Reflection;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.SoundMaker.Framework.Windows;

    /// <summary>
    /// ツール関連コマンドを管理します。
    /// </summary>
    public static class ToolCommands
    {
        /// <summary>
        /// ツール関連コマンドを列挙する IEnumerable を取得します。
        /// </summary>
        public static IEnumerable<Command> Commands
        {
            get
            {
                return ObjectFinder.FindStaticValues<Command>(typeof(ToolCommands),
                                                               BindingFlags.GetProperty | BindingFlags.GetField);
            }
        }

        /// <summary>
        /// 全発音停止。
        /// </summary>
        public static readonly Command StopAllSounds =
            new Command("Tool.StopAllSounds", MessageResource.Command_Tool_StopAllSounds_Name)
            {
#if false
                Text = MessageResource.Command_Tool_StopAllSounds_Text,
#endif
                Image = ImageResource.BitmapIconStopAllSounds.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// MIDIリセット。
        /// </summary>
        public static readonly Command ResetMidi =
            new Command("Tool.ResetMidi", MessageResource.Command_Tool_ResetMidi_Name)
            {
#if false
                Text = MessageResource.Command_Tool_ResetMidi_Text,
#endif
            };

        /// <summary>
        /// オプションの表示。
        /// </summary>
        public static readonly Command ShowOptions =
            new Command("Tool.ShowOptions", MessageResource.Command_Tool_ShowOptions_Name)
            {
#if false
                Text = MessageResource.Command_Tool_ShowOptions_Text,
#endif
            };

        /// <summary>
        /// ユーザーコマンドの編集
        /// </summary>
        public static readonly Command EditUserCommands =
            new Command("Tool.EditUserCommands", MessageResource.Command_Tool_EditUserCommands_Name)
            {
#if false
                Text = MessageResource.Command_Tool_EditUserCommands_Text,
#endif
            };

        /// <summary>
        /// ユーザーコマンド
        /// </summary>
        public static readonly Command UserCommand =
            new Command("Tool.UserCommand", "UserCommand") { };

        /// <summary>
        /// ユーザーコマンド1
        /// </summary>
        public static readonly Command UserCommand1 =
            new Command("Tool.UserCommand?Index=0", "UserCommand")
            {
                Image = ImageResource.BitmapIconUserCommand1.MakeNewTransparent
                (UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// ユーザーコマンド2
        /// </summary>
        public static readonly Command UserCommand2 =
            new Command("Tool.UserCommand?Index=1", "UserCommand")
            {
                Image = ImageResource.BitmapIconUserCommand2.MakeNewTransparent
                (UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// ユーザーコマンド3
        /// </summary>
        public static readonly Command UserCommand3 =
            new Command("Tool.UserCommand?Index=2", "UserCommand")
            {
                Image = ImageResource.BitmapIconUserCommand3.MakeNewTransparent
                (UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// ユーザーコマンド4
        /// </summary>
        public static readonly Command UserCommand4 =
            new Command("Tool.UserCommand?Index=3", "UserCommand")
            {
                Image = ImageResource.BitmapIconUserCommand4.MakeNewTransparent
                (UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// ユーザーコマンド5
        /// </summary>
        public static readonly Command UserCommand5 =
            new Command("Tool.UserCommand?Index=4", "UserCommand")
            {
                Image = ImageResource.BitmapIconUserCommand5.MakeNewTransparent
                (UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// ユーザーコマンド6
        /// </summary>
        public static readonly Command UserCommand6 =
            new Command("Tool.UserCommand?Index=5", "UserCommand")
            {
                Image = ImageResource.BitmapIconUserCommand6.MakeNewTransparent
                (UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// ユーザーコマンド7
        /// </summary>
        public static readonly Command UserCommand7 =
            new Command("Tool.UserCommand?Index=6", "UserCommand")
            {
                Image = ImageResource.BitmapIconUserCommand7.MakeNewTransparent
                (UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// ユーザーコマンド8
        /// </summary>
        public static readonly Command UserCommand8 =
            new Command("Tool.UserCommand?Index=7", "UserCommand")
            {
                Image = ImageResource.BitmapIconUserCommand8.MakeNewTransparent
                (UIServiceBase.TransparentColor),
            };
    }
}
