﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Commands
{
    using System.Collections.Generic;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Reflection;
    using NintendoWare.SoundMaker.Framework.Resources;

    /// <summary>
    /// サウンドリスト関連コマンドを管理します。
    /// </summary>
    public static class SoundListCommands
    {
        /// <summary>
        /// サウンドリスト関連コマンドを列挙する IEnumerable を取得します。
        /// </summary>
        public static IEnumerable<Command> Commands
        {
            get
            {
                return ObjectFinder.FindStaticValues<Command>(typeof(SoundListCommands),
                                                               BindingFlags.GetProperty | BindingFlags.GetField);
            }
        }

        /// <summary>
        /// ストリームサウンドの追加。
        /// </summary>
        public static readonly Command AddStreamSound =
            new Command("SoundList.AddStreamSound", string.Empty);

        /// <summary>
        /// ストリームサウンドトラックの追加。
        /// </summary>
        public static readonly Command AddStreamSoundTrack =
            new Command("SoundList.AddStreamSoundTrack", string.Empty);

        /// <summary>
        /// ウェーブサウンドセットの追加。
        /// </summary>
        public static readonly Command AddWaveSoundSet =
            new Command("SoundList.AddWaveSoundSet", string.Empty);

        /// <summary>
        /// ウェーブサウンドの追加。
        /// </summary>
        public static readonly Command AddWaveSound =
            new Command("SoundList.AddWaveSound", string.Empty);

        /// <summary>
        /// シーケンスサウンドの追加。
        /// </summary>
        public static readonly Command AddSequenceSound =
            new Command("SoundList.AddSequencesound", string.Empty);

        /// <summary>
        /// シーケンスサウンドセットの追加。
        /// </summary>
        public static readonly Command AddSequenceSoundSet =
            new Command("SoundList.AddSequenceSoundSet", string.Empty);

        /// <summary>
        /// バンクの追加。
        /// </summary>
        public static readonly Command AddBank =
            new Command("SoundList.AddBank", string.Empty);

        /// <summary>
        /// 波形アーカイブの追加。
        /// </summary>
        public static readonly Command AddWaveArchive =
            new Command("SoundList.AddWaveArchive", string.Empty);

        /// <summary>
        /// プレイヤーの追加。
        /// </summary>
        public static readonly Command AddPlayer =
            new Command("SoundList.AddPlayer", string.Empty);

        /// <summary>
        /// グループの追加。
        /// </summary>
        public static readonly Command AddGroup =
            new Command("SoundList.AddGroup", string.Empty);

        /// <summary>
        /// グループアイテムの追加。
        /// </summary>
        public static readonly Command AddGroupItem =
            new Command("SoundList.AddGroupItem", string.Empty);

        /// <summary>
        /// ストリームサウンドの挿入。
        /// </summary>
        public static readonly Command InsertStreamSound =
            new Command("SoundList.InsertStreamSound", string.Empty);

        /// <summary>
        /// ストリームサウンドトラックの挿入。
        /// </summary>
        public static readonly Command InsertStreamSoundTrack =
            new Command("SoundList.InsertStreamSoundTrack", string.Empty);

        /// <summary>
        /// ウェーブサウンドセットの挿入。
        /// </summary>
        public static readonly Command InsertWaveSoundSet =
            new Command("SoundList.InsertWaveSoundSet", string.Empty);

        /// <summary>
        /// ウェーブサウンドの挿入。
        /// </summary>
        public static readonly Command InsertWaveSound =
            new Command("SoundList.InsertWaveSound", string.Empty);

        /// <summary>
        /// シーケンスサウンドの挿入。
        /// </summary>
        public static readonly Command InsertSequenceSound =
            new Command("SoundList.InsertSequencesound", string.Empty);

        /// <summary>
        /// シーケンスサウンドセットの挿入。
        /// </summary>
        public static readonly Command InsertSequenceSoundSet =
            new Command("SoundList.InsertSequenceSoundSet", string.Empty);

        /// <summary>
        /// バンクの挿入。
        /// </summary>
        public static readonly Command InsertBank =
            new Command("SoundList.InsertBank", string.Empty);

        /// <summary>
        /// 波形アーカイブの追加。
        /// </summary>
        public static readonly Command InsertWaveArchive =
            new Command("SoundList.InsertWaveArchive", string.Empty);

        /// <summary>
        /// プレイヤーの挿入。
        /// </summary>
        public static readonly Command InsertPlayer =
            new Command("SoundList.InsertPlayer", string.Empty);

        /// <summary>
        /// グループの挿入。
        /// </summary>
        public static readonly Command InsertGroup =
            new Command("SoundList.InsertGroup", string.Empty);

        /// <summary>
        /// グループアイテムの挿入。
        /// </summary>
        public static readonly Command InsertGroupItem =
            new Command("SoundList.InsertGroupItem", string.Empty);

        /// <summary>
        /// グループに登録。
        /// </summary>
        public static readonly Command AddToGroup = new Command("SoundList.AddToGroup", string.Empty)
        {
#if false
            Text = MessageResource.Command_SoundList_AddToGroup_Text
#endif
        };

        /// <summary>
        /// HTMLインストルメントリストの出力。
        /// </summary>
        public static readonly Command OutputHtmlInstrumentList = new Command("SoundList.OutputHtmlInstrumentList", string.Empty)
        {
#if false
            Text = MessageResource.Command_SoundList_OutputHtmlInstrumentList_Text
#endif
        };
    }
}
