﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Commands
{
    using System.Collections.Generic;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Core.Reflection;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.SoundMaker.Framework.Windows;

    /// <summary>
    /// プレビュー関連コマンドを管理します。
    /// </summary>
    public static class PreviewCommands
    {
        /// <summary>
        /// プレビュー関連コマンドを列挙する IEnumerable を取得します。
        /// </summary>
        public static IEnumerable<Command> Commands
        {
            get
            {
                return ObjectFinder.FindStaticValues<Command>(
                    typeof(PreviewCommands),
                    BindingFlags.GetProperty | BindingFlags.GetField);
            }
        }

        /// <summary>
        /// 再生する。
        /// </summary>
        public static readonly Command Play =
            new Command("Preview.Play", MessageResource.Command_Preview_Play_Name)
            {
#if false
                Text = MessageResource.Command_Preview_Play_Text,
#endif
                Image = ImageResource.BitmapIconPlay.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// 再生する。
        /// Playコマンドと名前以外を同じにする必要があります。
        /// </summary>
        public static readonly Command Play2 =
            new Command("Preview.Play2", MessageResource.Command_Preview_Play_Name)
            {
                Image = ImageResource.BitmapIconPlay.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// 再生する。
        /// </summary>
        public static readonly Command PlayKeySpaceWithShift =
            new Command("Preview.PlayKeySpaceWithShift", MessageResource.Command_Preview_Play_Name)
            {
            };

        /// <summary>
        /// 全て再生する。
        /// </summary>
        public static readonly Command PlayAll =
            new Command("Preview.PlayAll", MessageResource.Command_Preview_PlayAll_Name)
            {
                Image = ImageResource.BitmapIconPlay.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// 全て一時停止する。
        /// </summary>
        public static readonly Command PauseAll =
            new Command("Preview.PauseAll", MessageResource.Command_Preview_PauseAll_Name)
            {
#if false
                Text = MessageResource.Command_Preview_PauseAll_Text,
#endif
                Image = ImageResource.BitmapIconPause.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// 全て停止する。
        /// </summary>
        public static readonly Command StopAll =
            new Command("Preview.StopAll", MessageResource.Command_Preview_StopAll_Name)
            {
#if false
                Text = MessageResource.Command_Preview_StopAll_Text,
#endif
                Image = ImageResource.BitmapIconStop.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// プレビューバンクに登録。
        /// </summary>
        public static readonly Command RegisterOnPreviewBank =
            new Command("Preview.RegisterOnPreviewBank", string.Empty)
            {
#if false
                Text = MessageResource.Command_SoundList_RegisterOnPreviewBank_Text
#endif
            };

        /// <summary>
        /// プレビューバンクに登録。(タブからの登録)
        /// "RegisterOnPreviewBank"とは登録の意味が違うので分けてあります。
        /// </summary>
        public static readonly Command RegisterOnPreviewBankFromPanel =
            new Command("Preview.RegisterOnPreviewBankFromPanel", string.Empty)
            {
            };

        /// <summary>
        /// 波形ファイルの出力。
        /// </summary>
        public static readonly Command OutputWaveFile =
            new Command("Preview.OutputWaveFile", MessageResource.Command_Preview_OutputWaveFile_Name)
            {
#if false
                Text = MessageResource.Command_Preview_OutputWaveFile_Text,
#endif
            };

        /// <summary>
        /// 平均ラウドネス値の計測。
        /// </summary>
        public static readonly Command MeasureIntegratedLoudness =
            new Command("Preview.MeasureIntegratedLoudness", MessageResource.Command_Preview_MeasureIntegratedLoudness_Name)
            {
#if false
                Text = MessageResource.Command_Preview_MeasureIntegratedLoudness_Text,
#endif
            };

        /// <summary>
        /// テキストシーケンスを波形化。
        /// </summary>
        public static readonly Command WaveConvert =
            new Command("_Preview.WaveConvert", MessageResource.Command_Preview_WaveConvert_Name);

        /// <summary>
        /// テキストシーケンスを波形化してプレビュー。
        /// </summary>
        public static readonly Command WaveConvertAndPreview =
            new Command("_Preview.WaveConvertAndPreview", MessageResource.Command_Preview_WaveConvertAndPreview_Name);

        /// <summary>
        /// 波形化テキストシーケンスファイルを開く。
        /// </summary>
        public static readonly Command OpenTextSequenceForWave =
            new Command("_Preview.OpenTextSequenceForWave", MessageResource.Command_Preview_OpenTextSequenceForWave_Name);

        /// <summary>
        /// 波形の参照回数を計測
        /// </summary>
        public static readonly Command MeasureWaveReferenceCount =
            new Command("Preview.MeasureWaveReferenceCount", MessageResource.Command_Preview_MeasureWaveReferenceCount_Name)
            {
            };

        /// <summary>
        /// シーケンスの最大発音数を計測
        /// </summary>
        public static readonly Command MeasureSequenceVoiceCount =
            new Command("Preview.MeasureSequenceVoiceCount", MessageResource.Command_Preview_MeasureSequenceVoiceCount_Name)
            {
            };
    }
}
