﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Commands
{
    using System.Collections.Generic;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Core.Reflection;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.SoundMaker.Framework.Windows;

    /// <summary>
    /// ヘルプ関連コマンドを管理します。
    /// </summary>
    public static class HelpCommands
    {
        /// <summary>
        /// ヘルプ関連コマンドを列挙する IEnumerable を取得します。
        /// </summary>
        public static IEnumerable<Command> Commands
        {
            get
            {
                return ObjectFinder.FindStaticValues<Command>(typeof(HelpCommands),
                                                               BindingFlags.GetProperty | BindingFlags.GetField);
            }
        }

        /// <summary>
        /// ヘルプの表示。
        /// </summary>
        public static readonly Command ShowHelp =
            new Command("Help.ShowHelp", MessageResource.Command_Help_ShowHelp_Name)
            {
#if false
                Text = MessageResource.Command_Help_ShowHelp_Text,
#endif
                Image = ImageResource.BitmapIconHelp.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// トラブルシューティングヘルプの表示。
        /// </summary>
        public static readonly Command ShowTroubleshootingHelp = new Command("Help.ShowTroubleshootingHelp", MessageResource.Command_Help_ShowTroubleshootingHelp_Name);

        /// <summary>
        /// Viewerヘルプの表示。
        /// </summary>
        public static readonly Command ShowViewerHelp =
            new Command("Help.ShowViewerHelp", MessageResource.Command_Help_ShowViewerHelp_Name)
            {
#if false
                Text = MessageResource.Command_Help_ShowViewerHelp_Text,
#endif
            };

        /// <summary>
        /// バージョン情報。
        /// </summary>
        public static readonly Command About =
            new Command("Help.About", MessageResource.Command_Help_About_Name)
            {
#if false
                Text = MessageResource.Command_Help_About_Text,
#endif
            };
    }
}
