﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Commands
{
    using System.Collections.Generic;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Core.Reflection;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.SoundMaker.Framework.Windows;

    /// <summary>
    /// ファイル関連コマンドを管理します。
    /// </summary>
    public static class FileCommands
    {
        /// <summary>
        /// ファイル関連コマンドを列挙する IEnumerable を取得します。
        /// </summary>
        public static IEnumerable<Command> Commands
        {
            get
            {
                return ObjectFinder.FindStaticValues<Command>(
                                                              typeof(FileCommands),
                                                              BindingFlags.GetProperty |
                                                              BindingFlags.GetField
                                                              );
            }
        }

        /// <summary>
        /// 終了。
        /// </summary>
        public static readonly Command ExitApplication =
            new Command("File.Exit", MessageResource.Command_File_Exit_Name)
            {
#if false
                Text = MessageResource.Command_File_Exit_Text,
#endif
            };

        /// <summary>
        /// プロジェクトの新規作成。
        /// </summary>
        public static readonly Command NewProject =
            new Command("File.NewProject", MessageResource.Command_File_NewProject_Name)
            {
#if false
                Text = MessageResource.Command_File_NewProject_Text,
#endif
            };

        /// <summary>
        /// プロジェクトを開く。
        /// </summary>
        public static readonly Command OpenProject =
            new Command("File.OpenProject", MessageResource.Command_File_OpenProject_Name)
            {
#if false
                Text = MessageResource.Command_File_OpenProject_Text,
#endif
                Image =
                   ImageResource.BitmapIconOpen.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// ファイルを開く。
        /// </summary>
        public static readonly Command OpenFile =
            new Command("File.OpenFile", MessageResource.Command_File_OpenFile_Name)
            {
#if false
                Text = MessageResource.Command_File_OpenFile_Text,
#endif
            };

        /// <summary>
        /// ドキュメントを閉じる。
        /// </summary>
        public static readonly Command CloseDocument =
            new Command("File.CloseDocument", MessageResource.Command_File_CloseDocument_Name)
            {
#if false
                Text = MessageResource.Command_File_CloseDocument_Text
#endif
            };

        /// <summary>
        /// 他のドキュメントをすべて閉じる。
        /// </summary>
        public static readonly Command CloseOtherDocuments =
            new Command("File.CloseOtherDocuments", string.Empty)
            {
#if false
                Text = MessageResource.Command_File_CloseOtherDocuments_Text
#endif
            };

        /// <summary>
        /// すべてのドキュメントを閉じる。
        /// </summary>
        public static readonly Command CloseAllDocuments =
            new Command("File.CloseAllDocuments", string.Empty)
            {
#if false
                Text = MessageResource.Command_File_CloseAllDocuments_Text
#endif
            };

        /// <summary>
        /// プロジェクトを閉じる。
        /// </summary>
        public static readonly Command CloseProject =
            new Command("File.CloseProject", MessageResource.Command_File_CloseProject_Name)
            {
#if false
                Text = MessageResource.Command_File_CloseProject_Text,
#endif
            };

        /// <summary>
        /// すべてを保存。
        /// </summary>
        public static readonly Command SaveAll =
            new Command("File.SaveAll", MessageResource.Command_File_SaveAll_Name)
            {
#if false
                Text = MessageResource.Command_File_SaveAll_Text,
#endif
                Image =
                ImageResource.BitmapIconSaveAll.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// プロジェクトの再読み込み。
        /// </summary>
        public static readonly Command ReloadProject =
            new Command("File.ReloadProject", MessageResource.Command_File_ReloadProject_Name)
            {
#if false
                Text = MessageResource.Command_File_ReloadProject_Text,
#endif
            };

        /// <summary>
        /// フォルダを開く。
        /// </summary>
        public static readonly Command OpenItemFolder =
            new Command("File.OpenItemFolder", MessageResource.Command_Project_OpenItemFolder_Name)
            {
#if false
                Text = MessageResource.Command_Project_OpenItemFolder_Text,
#endif
                Image = ImageResource.BitmapIconOpenItemFolder.MakeNewTransparent(
                            UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// 参照ファイルを開く。
        /// </summary>
        public static readonly Command ExecuteItemFile =
            new Command(
                        "File.ExecuteItemFile",
                        MessageResource.Command_Project_ExecuteItemFile_Name
                        )
            {
#if false
                Text = MessageResource.Command_Project_ExecuteItemFile_Text,
#endif
            };

        /// <summary>
        /// 参照バンクを開く。
        /// </summary>
        public static readonly Command OpenBankItem =
            new Command(
                        "File.OpenBankItem",
                        MessageResource.Command_Project_OpenBankItem_Name
                        )
            {
#if false
                Text = MessageResource.Command_Project_OpenBankItem_Text,
#endif
            };

        /// <summary>
        /// 別プラットフォームのプロジェクトのインポート
        /// </summary>
        public static readonly Command ImportProject =
            new Command("File.ImportProject", MessageResource.Command_File_ImportProject_Name)
            {
#if false
                Text = MessageResource.Command_File_ImportProject_Text,
#endif
                Image =
                ImageResource.BitmapIconOpen.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// SoundSetのインポート
        /// </summary>
        public static readonly Command ImportSoundSet =
            new Command("File.ImportSoundSet", MessageResource.Command_File_ImportSoundSet_Name)
            {
#if false
                Text = MessageResource.Command_File_ImportSoundSet_Text,
#endif
            };

        /// <summary>
        /// Bankのインポート
        /// </summary>
        public static readonly Command ImportBank =
            new Command("File.ImportBank", MessageResource.Command_File_ImportBank_Name)
            {
#if false
                Text = MessageResource.Command_File_ImportBank_Text,
#endif
            };

        /// <summary>
        /// DLSのインポート
        /// </summary>
        public static readonly Command ImportDLS =
            new Command("File.ImportDLS", MessageResource.Command_File_ImportDLS_Name)
            {
#if false
                Text = MessageResource.Command_File_ImportDLS_Text,
#endif
            };

        /// <summary>
        /// Stxtのインポート
        /// </summary>
        public static readonly Command ImportStxt =
            new Command("File.ImportStxt", MessageResource.Command_File_ImportStxt_Name)
            {
#if false
                Text = MessageResource.Command_File_ImportStxt_Text,
#endif
            };
    }
}
