﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Commands
{
    using System.Collections.Generic;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Core.Reflection;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.SoundMaker.Framework.Windows;

    /// <summary>
    /// 編集関連コマンドを管理します。
    /// </summary>
    public static class EditCommands
    {
        /// <summary>
        /// 編集関連コマンドを列挙する IEnumerable を取得します。
        /// </summary>
        public static IEnumerable<Command> Commands
        {
            get
            {
                return ObjectFinder.FindStaticValues<Command>(typeof(EditCommands),
                                                               BindingFlags.GetProperty | BindingFlags.GetField);
            }
        }

        /// <summary>
        /// 元に戻す。
        /// </summary>
        public static readonly Command Undo = new Command("Edit.Undo", MessageResource.Command_Edit_Undo_Name)
        {
#if false
            Text = MessageResource.Command_Edit_Undo_Text,
#endif
            Image = ImageResource.BitmapIconUndo.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// やり直し。
        /// </summary>
        public static readonly Command Redo = new Command("Edit.Redo", MessageResource.Command_Edit_Redo_Name)
        {
#if false
            Text = MessageResource.Command_Edit_Redo_Text,
#endif
            Image = ImageResource.BitmapIconRedo.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// コピー。
        /// </summary>
        public static readonly Command Copy = new Command("Edit.Copy", MessageResource.Command_Edit_Copy_Name)
        {
#if false
            Text = MessageResource.Command_Edit_Copy_Text,
#endif
            Image = ImageResource.BitmapIconCopy.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// セルのコピー。
        /// </summary>
        public static readonly Command CopyCell = new Command("Edit.CopyCell", MessageResource.Command_Edit_CopyCell_Name)
        {
#if false
            Text = MessageResource.Command_Edit_CopyCell_Text,
#endif
        };

        /// <summary>
        /// 貼り付け。
        /// </summary>
        public static readonly Command Paste = new Command("Edit.Paste", MessageResource.Command_Edit_Paste_Name)
        {
#if false
            Text = MessageResource.Command_Edit_Paste_Text,
#endif
            Image = ImageResource.BitmapIconPaste.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// 項目を選択して貼り付け。
        /// </summary>
        public static readonly Command PasteSpecial = new Command("Edit.PasteSpecial", MessageResource.Command_Edit_PasteSpecial_Name)
        {
#if false
            Text = MessageResource.Command_Edit_PasteSpecial_Text,
#endif
        };

        /// <summary>
        /// 切り取り。
        /// </summary>
        public static readonly Command Cut = new Command("Edit.Cut", MessageResource.Command_Edit_Cut_Name)
        {
#if false
            Text = MessageResource.Command_Edit_Cut_Text,
#endif
            Image = ImageResource.BitmapIconCut.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// 削除。
        /// </summary>
        public static readonly Command Delete = new Command("Edit.Delete", MessageResource.Command_Edit_Delete_Name)
        {
#if false
            Text = MessageResource.Command_Edit_Delete_Text,
#endif
            Image = ImageResource.BitmapIconDelete.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// すべて選択。
        /// </summary>
        public static readonly Command SelectAll = new Command("Edit.SelectAll", MessageResource.Command_Edit_SelectAll_Name)
        {
#if false
            Text = MessageResource.Command_Edit_SelectAll_Text,
#endif
        };

        /// <summary>
        /// アイテムのカラー。
        /// </summary>
        public static readonly Command SetItemColor = new Command("Edit.SetItemColor?ColorIndex=0", string.Empty)
        {
#if false
            Text = MessageResource.Command_Edit_SetItemColor_Text,
#endif
        };

        /// <summary>
        /// アイテムのカラー(赤)。
        /// </summary>
        public static readonly Command SetItemColorRed = new Command("Edit.SetItemColor?ColorIndex=1", string.Empty)
        {
#if false
            Text = MessageResource.Command_Edit_SetItemColor_Text,
#endif
            Image = ImageResource.BitmapIconItemColorRed.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// アイテムのカラー(オレンジ)。
        /// </summary>
        public static readonly Command SetItemColorOrange = new Command("Edit.SetItemColor?ColorIndex=2", string.Empty)
        {
#if false
            Text = MessageResource.Command_Edit_SetItemColor_Text,
#endif
            Image = ImageResource.BitmapIconItemColorOrange.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// アイテムのカラー(黄)。
        /// </summary>
        public static readonly Command SetItemColorYellow = new Command("Edit.SetItemColor?ColorIndex=3", string.Empty)
        {
#if false
            Text = MessageResource.Command_Edit_SetItemColor_Text,
#endif
            Image = ImageResource.BitmapIconItemColorYellow.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// アイテムのカラー(緑)。
        /// </summary>
        public static readonly Command SetItemColorGreen = new Command("Edit.SetItemColor?ColorIndex=4", string.Empty)
        {
#if false
            Text = MessageResource.Command_Edit_SetItemColor_Text,
#endif
            Image = ImageResource.BitmapIconItemColorGreen.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// アイテムのカラー(水色)。
        /// </summary>
        public static readonly Command SetItemColorLightBlue = new Command("Edit.SetItemColor?ColorIndex=5", string.Empty)
        {
#if false
            Text = MessageResource.Command_Edit_SetItemColor_Text,
#endif
            Image = ImageResource.BitmapIconItemColorLightBlue.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// アイテムのカラー(青)。
        /// </summary>
        public static readonly Command SetItemColorBlue = new Command("Edit.SetItemColor?ColorIndex=6", string.Empty)
        {
#if false
            Text = MessageResource.Command_Edit_SetItemColor_Text,
#endif
            Image = ImageResource.BitmapIconItemColorBlue.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// アイテムのカラー(紫)。
        /// </summary>
        public static readonly Command SetItemColorPurple = new Command("Edit.SetItemColor?ColorIndex=7", string.Empty)
        {
#if false
            Text = MessageResource.Command_Edit_SetItemColor_Text,
#endif
            Image = ImageResource.BitmapIconItemColorPurple.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// アイテムのカラー(ピンク)。
        /// </summary>
        public static readonly Command SetItemColorPink = new Command("Edit.SetItemColor?ColorIndex=8", string.Empty)
        {
#if false
            Text = MessageResource.Command_Edit_SetItemColor_Text,
#endif
            Image = ImageResource.BitmapIconItemColorPink.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// アイテムを有効にする。
        /// </summary>
        public static readonly Command EnableItem = new Command("Edit.EnableItem", MessageResource.Command_Edit_EnableItem_Name)
        {
#if false
            Text = MessageResource.Command_Edit_EnableItem_Text,
#endif
        };

        /// <summary>
        /// アイテムを無効にする。
        /// </summary>
        public static readonly Command DisableItem = new Command("Edit.DisableItem", MessageResource.Command_Edit_DisableItem_Name)
        {
#if false
            Text = MessageResource.Command_Edit_DisableItem_Text,
#endif
        };

        /// <summary>
        /// アイテムをインゲーム編集対象にする
        /// </summary>
        public static readonly Command EnableSndEdit = new Command("Edit.EnableSndEdit", MessageResource.Command_Edit_EnableSndEdit_Name)
        {
        };

        /// <summary>
        /// アイテムをインゲーム編集対象から外す
        /// </summary>
        public static readonly Command DisableSndEdit = new Command("Edit.DisableSndEdit", MessageResource.Command_Edit_DisableSndEdit_Name)
        {
        };

        /// <summary>
        /// ウェーブサウンドで波形ファイルを使用する
        /// </summary>
        public static readonly Command UseWaveSoundWaveFile = new Command("Edit.UseWaveSoundWaveFile", MessageResource.Command_Edit_UseWaveSoundWaveFile_Name)
        {
        };

        /// <summary>
        /// ウェーブサウンドリソースを使用する
        /// </summary>
        public static readonly Command UseWaveSoundResource = new Command("Edit.UseWaveSoundResource", MessageResource.Command_Edit_UseWaveSoundResource_Name)
        {
        };

        /// <summary>
        /// 1トラックに統合する
        /// </summary>
        public static readonly Command CombineAACTrack = new Command("Edit.CombineAACTrack", MessageResource.Command_Edit_CombineAACTrack_Name)
        {
        };

        /// <summary>
        /// 2トラックに分割する
        /// </summary>
        public static readonly Command DivideAACTrack = new Command("Edit.DivideAACTrack", MessageResource.Command_Edit_DivideAACTrack_Name)
        {
        };

        /// <summary>
        /// 一括編集。
        /// </summary>
        public static readonly Command BatchEdit = new Command("Edit.BatchEdit", MessageResource.Command_Edit_BatchEdit_Name)
        {
#if false
            Text = MessageResource.Command_Edit_BatchEdit_Text,
#endif
        };

        /// <summary>
        /// プログラムナンバーの振り直し。
        /// </summary>
        public static readonly Command RenumberProgramNo = new Command("Edit.RenumberProgramNo", MessageResource.Command_Edit_RenumberProgramNo_Name)
        {
#if false
            Text = MessageResource.Command_Edit_RenumberProgramNo_Text,
#endif
        };

        /// <summary>
        /// 検索ウィンドウの表示。
        /// </summary>
        public static readonly Command ShowFindWindow = new Command("Edit.ShowFindWindow", MessageResource.Command_Edit_ShowFindWindow_Name)
        {
#if false
            Text = MessageResource.Command_Edit_ShowFindWindow_Text,
#endif
        };

        /// <summary>
        /// サウンドセット検索タブを開く
        /// </summary>
        public static readonly Command OpenSoundSetFindTabPage = new Command("Edit.OpenSoundSetFindTabPage", MessageResource.Command_Edit_OpenSoundSetFindTabPage_Name)
        {
        };

        /// <summary>
        /// インストルメント検索タブを開く
        /// </summary>
        public static readonly Command OpenInstrumentFindTabPage = new Command("Edit.OpenInstrumentFindTabPage", MessageResource.Command_Edit_OpenInstrumentFindTabPage_Name)
        {
        };

        /// <summary>
        /// すべての参照の検索。
        /// </summary>
        public static readonly Command FindReferences = new Command("Edit.FindReferences", MessageResource.Command_Edit_FindReferences_Name)
        {
#if false
            Text = MessageResource.Command_Edit_FindReferences_Text,
#endif
        };

        /// <summary>
        /// マルチバンクの編集。
        /// </summary>
        public static readonly Command ShowMultipleBankSettings = new Command("Edit.ShowMultipleBankSettings", MessageResource.Command_Edit_ShowMultipleBankSettings_Name)
        {
#if false
            Text = MessageResource.Command_Edit_ShowMultipleBankSettings_Text,
#endif
        };

        /// <summary>
        /// ブックマークに追加
        /// </summary>
        public static readonly Command AddBookmark = new Command("Edit.AddBookmark", MessageResource.Command_Edit_AddBookmark_Name)
        {
#if false
            Text = MessageResource.Command_Edit_AddBookmark_Text,
#endif
        };

        /// <summary>
        /// ブックマークフォルダの作成
        /// </summary>
        public static readonly Command CreateBookmarkFolder = new Command("Edit.CreateBookmarkFolder", MessageResource.Command_Edit_CreateBookmarkFolder_Name)
        {
#if false
            Text = MessageResource.Command_Edit_CreateBookmarkFolder_Text,
#endif
        };

        /// <summary>
        /// ブックマーク名の変更
        /// </summary>
        public static readonly Command RenameBookmark = new Command("Edit.RenameBookmark", MessageResource.Command_Edit_RenameBookmark_Name)
        {
#if false
            Text = MessageResource.Command_Edit_RenameBookmark_Text,
#endif
        };
    }
}
