﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using NintendoWare.SoundFoundation.CommandHandlers;

namespace NintendoWare.SoundMaker.Framework.CommandHandlers
{
    /// <summary>
    /// コマンド参照をキーとしたコマンドバインディングコレクションです。
    /// </summary>
    public class CommandBindingCollection : KeyedCollection<string, CommandBinding>
    {
        /// <summary>
        /// コマンドバインディングからキーとなるコマンドIDを取得します。
        /// </summary>
        /// <param name="item">コマンドバインディング。</param>
        /// <returns>コマンドID。</returns>
        protected override string GetKeyForItem(CommandBinding item)
        {
            return item.CommandID;
        }
    }
}
