﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Windows.Forms
{
    using NintendoWare.SoundFoundation.Projects;

    public static class PreviewPlayEventListener
    {
        /// <summary>
        ///
        /// </summary>
        public static void OnPreviewPlay(object sender, EventArgs e)
        {
            Component component = sender as Component;
            PreviewPlayerOperator.Play(component);
        }

        /// <summary>
        ///
        /// </summary>
        public static void OnPreviewMute(object sender, EventArgs e)
        {
            StreamSoundTrackBase targetTrack = sender as StreamSoundTrackBase;
            StreamSoundBase stream = targetTrack.Parent as StreamSoundBase;

            targetTrack.PreviewMute = !targetTrack.PreviewMute;
            if (targetTrack.PreviewMute != false)
            {
                targetTrack.PreviewSoloPlay = false;
            }
            else
            {
                if (ContainsSoloPlay(stream) != false)
                {
                    targetTrack.PreviewSoloPlay = true;
                }
            }

            //
            PreviewPlayerOperator.MuteChannel(targetTrack, targetTrack.PreviewMute);
        }

        /// <summary>
        ///
        /// </summary>
        public static void OnPreviewSoloPlay(object sender, EventArgs e)
        {
            StreamSoundTrackBase targetTrack = sender as StreamSoundTrackBase;
            StreamSoundBase stream = targetTrack.Parent as StreamSoundBase;
            targetTrack.PreviewSoloPlay = !targetTrack.PreviewSoloPlay;

            //
            if (targetTrack.PreviewSoloPlay != false)
            {
                // 一つ目のSoloPlayが設定される場合には、全てのMute状態を保存します。
                if (ContainsSoloPlay(stream, targetTrack) == false)
                {
                    foreach (StreamSoundTrackBase track in stream.Children)
                    {
                        track.PreviousPreviewMute = track.PreviewMute;
                    }
                }

                targetTrack.PreviewMute = false;

                foreach (StreamSoundTrackBase track in stream.Children)
                {
                    if (track != targetTrack &&
                        track.PreviewSoloPlay == false)
                    {
                        track.PreviewMute = true;
                    }
                }
            }
            else
            {
                bool contains = ContainsSoloPlay(stream);
                foreach (StreamSoundTrackBase track in stream.Children)
                {
                    if (track.PreviewSoloPlay == false)
                    {
                        if (contains != false)
                        {
                            track.PreviewMute = true;
                        }
                        else
                        {
                            track.PreviewMute = track.PreviousPreviewMute;
                        }
                    }
                }
            }

            //
            foreach (StreamSoundTrackBase track in stream.Children)
            {
                PreviewPlayerOperator.MuteChannel(track, track.PreviewMute);
            }
        }

        /// <summary>
        ///
        /// </summary>
        private static bool ContainsSoloPlay(StreamSoundBase stream, StreamSoundTrackBase excludeTrack)
        {
            foreach (StreamSoundTrackBase track in stream.Children)
            {
                if (track != excludeTrack &&
                    track.PreviewSoloPlay != false)
                {
                    return true;
                }
            }
            return false;
        }

        /// <summary>
        ///
        /// </summary>
        private static bool ContainsSoloPlay(StreamSoundBase stream)
        {
            foreach (StreamSoundTrackBase track in stream.Children)
            {
                if (track.PreviewSoloPlay != false)
                {
                    return true;
                }
            }
            return false;
        }
    }
}
