﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Windows.Forms;

namespace NintendoWare.SoundMaker.Windows.Forms
{
    public partial class SeqVariableControl : NUserControl
    {
        // パラメータ
        private uint _index = 0;
        private int _currentValue = Preview.SeqVariable.InvalidValue;


        public SeqVariableControl()
        {
            InitializeComponent();

            UpdateIndex();
            UpdateForeColor();
        }

        #region ** プロパティ

        [Category("Behavior")]
        [DefaultValue(false)]
        public bool Checked
        {
            get { return _check.Checked; }
            set { _check.Checked = value; }
        }

        [Category("Appearance")]
        [DefaultValue(0)]
        public uint Index
        {
            get { return _index; }
            set
            {
                if (value == _index) { return; }

                _index = value;
                UpdateIndex();
            }
        }

        [Category("Behavior")]
        public int EditValue
        {
            get { return Convert.ToInt32(_varEdit.Value); }
            set { _varEdit.Value = Convert.ToDecimal(value); }
        }

        [Category("Behavior")]
        [ReadOnly(true)]
        public int CurrentValue
        {
            get { return _currentValue; }
            set
            {
                if (value != Preview.SeqVariable.InvalidValue)
                {

                    Debug.Assert(value >= _varEdit.Minimum);
                    Debug.Assert(value <= _varEdit.Maximum);
                    _varValue.Text = value.ToString();

                }
                else
                {
                    _varValue.Text = "-";
                }

                _currentValue = value;
            }
        }

        #endregion

        #region ** イベント

        public event EventHandler CheckedChanged;
        public event ValueChangedEventHandler ValueChanged;

        #endregion

        #region ** イベントハンドラ

        private void OnCheckedChanged(object sender, EventArgs e)
        {
            UpdateForeColor();

            if (null != CheckedChanged)
            {
                CheckedChanged(this, e);
            }
        }

        private void OnValueChanged(object sender, ValueChangedEventArgs e)
        {
            if (null != ValueChanged)
            {
                ValueChanged(this, e);
            }
        }

        #endregion

        #region ** メソッド

        private void UpdateIndex()
        {
            _check.Text = _index.ToString() + " :";
        }

        private void UpdateForeColor()
        {
            Color textColor = (_check.Checked) ? SystemColors.ControlText : SystemColors.GrayText;

            _check.ForeColor = textColor;
            _varEdit.ForeColor = textColor;
        }

        #endregion

    }
}
