﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Windows.Forms;
using NW4R.ProtocolSound;

namespace NintendoWare.SoundMaker.Windows.Forms
{
    public partial class EffectParameterControl : NUserControl
    {
        private Preview.EffectParameter _effectParameter;

        public EffectParameterControl()
        {
            InitializeComponent();
        }

        #region ** プロパティ

        public Preview.EffectParameter Parameter
        {
            get { return _effectParameter; }
            set
            {
                if (value == _effectParameter) { return; }

                // イベントハンドラを差し替えて、パラメータ参照を更新する
                if (null != _effectParameter)
                {
                    _effectParameter.ParameterChanged -= OnParameterChanged;
                }
                value.ParameterChanged += OnParameterChanged;

                _effectParameter = value;
                OnParameterChanged(_effectParameter, new EventArgs());
            }
        }

        #endregion

        #region ** イベントハンドラ

        public virtual void OnParameterChanged(object sender, EventArgs e) { }

        #endregion
    }

    #region ** エフェクトパラメータ共用クラス

    public class FusedModeItem
    {
        private ToolSoundFusedMode _fusedMode = ToolSoundFusedMode.FusedMode_OldAxfx;
        private string _text = "";

        public FusedModeItem(ToolSoundFusedMode fusedMode, string text)
        {
            _fusedMode = fusedMode;
            _text = text;
        }

        #region ** プロパティ

        public ToolSoundFusedMode FusedMode
        {
            get { return _fusedMode; }
        }

        #endregion

        #region ** メソッドのオーバーライド

        public override string ToString()
        {
            return _text;
        }

        #endregion
    }

    public class EffectMessage
    {
        public static string FromEffectType(ToolSoundEffectType effectType)
        {
            switch (effectType)
            {
                case ToolSoundEffectType.EffectType_NoEffect:
                    return Resources.MessageResource.Label_EffectType_NoEffect;

                case ToolSoundEffectType.EffectType_ReverbHi:
                    return Resources.MessageResource.Label_EffectType_ReverbHi;

                case ToolSoundEffectType.EffectType_ReverbStd:
                    return Resources.MessageResource.Label_EffectType_ReverbStd;

                case ToolSoundEffectType.EffectType_Chorus:
                    return Resources.MessageResource.Label_EffectType_Chorus;

                case ToolSoundEffectType.EffectType_Delay:
                    return Resources.MessageResource.Label_EffectType_Delay;

                case ToolSoundEffectType.EffectType_MultiChannelReverb:
                    return Resources.MessageResource.Label_EffectType_MultiChannelReverb_Short;

                case ToolSoundEffectType.EffectType_MultiChannelChorus:
                    return Resources.MessageResource.Label_EffectType_MultiChannelChorus_Short;

                case ToolSoundEffectType.EffectType_MultiChannelDelay:
                    return Resources.MessageResource.Label_EffectType_MultiChannelDelay_Short;
            }

            Debug.Assert(false);
            return "";
        }
    }

    #endregion
}
