﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using System.Linq;
    using System.Text;
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Configurations;
    using NintendoWare.SoundMaker.Framework;
    using NintendoWare.SoundMaker.Framework.Configurations;
    using NintendoWare.SoundMaker.Framework.FileFormats;
    using NintendoWare.SoundMaker.Framework.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.Projects;
    using NintendoWare.SoundMakerPlugin;

    public class ListCtrlCommon : CommonListCtrl
    {
        public static readonly IParameterValue[] EncodingValues = new[] {
            new WaveEncodingParameterValue(WaveEncoding.Adpcm),
            new WaveEncodingParameterValue(WaveEncoding.Pcm16),
            new WaveEncodingParameterValue(WaveEncoding.Pcm8),
        };

        public ListCtrlCommon()
        {
            AddListColumnStyle(this);
            this.ReplaceArgumentDelegates.Add(ProjectParameterNames.WaveEncoding, this.ReplaceArgumentWaveEncoding);
        }

        public static void AddListColumnStyle(CommonListCtrl listCtrl)
        {
            ListColumnStyle listColumnStyle =
                new ListColumnStyle(ListTraitsCommon.ColumnName_RemoteFilter, "Integer", typeof(int));
            listCtrl.ColumnStyles.Add(listColumnStyle);

            listColumnStyle =
                new ListColumnStyle(ListTraitsCommon.ColumnName_AuxCSend, "Integer", typeof(int));
            listCtrl.ColumnStyles.Add(listColumnStyle);

            DropDownListInplaceEditor.Argument arg =
                new DropDownListInplaceEditor.Argument(_InterpolationTypeValues);
            listColumnStyle =
                new ListColumnStyle(ListTraits.ColumnName_InterpolationType, "DropDownList", typeof(string), new ListSubItemArgument(null, arg));
            listCtrl.ColumnStyles.Add(listColumnStyle);
        }

        ///
        private static IParameterValue[] _InterpolationTypeValues = new[] {
            new InterpolationTypeParameterValue(InterpolationType.Polyphase),
            new InterpolationTypeParameterValue(InterpolationType.Linear),
        };

        /// <summary>
        ///
        /// </summary>
        private IInplaceEditorArgument ReplaceArgumentWaveEncoding(ListColumnStyle style,
                                                                   IInplaceEditorArgument origArgs,
                                                                   ComponentListItem item)
        {
            if (item.Target is StreamSoundBase)
            {
                StreamSoundBase streamSound = item.Target as StreamSoundBase;
                StreamSoundTrack track = streamSound.Children[0] as StreamSoundTrack;
                if (AACUtil.IsAACFile(track.FilePath) == true || FileUtil.IsOpusFile(track.FilePath))
                {
                    return new DropDownListInplaceEditor.Argument(new[] { new WaveEncodingParameterValue(WaveEncoding.NoConvert) });
                }
            }

            ISoundMakerPlugin plugin = SoundMakerPluginManager.Instance.CurrentSoundMakerPlugin;
            return new DropDownListInplaceEditor.Argument(EncodingValues.Where(e => plugin.IsValidateWaveEncodingValue((WaveEncoding)e.Value)).ToArray());
        }
    }
}
