﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using NintendoWare.SoundFoundation.Projects;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;

namespace NintendoWare.SoundMaker.Preview.Service
{
    public delegate void MeasureLoudnessEventHandler(object sender, MeasureLoudnessEventArgs e);

    public class MeasureLoudnessEventArgs : EventArgs
    {
        public MeasureLoudnessEventArgs(IEnumerable<Sound> sounds, bool success = true, bool cancel = false)
        {
            this.Sounds = sounds.ToArray();
            this.IsSuccess = success;
            this.IsCancel = cancel;
        }

        public MeasureLoudnessEventArgs(IEnumerable<Sound> sounds, IEnumerable<float> integratedLoudness)
            : this(sounds)
        {
            this.IntegratedLoudness = integratedLoudness.ToArray();
        }

        // <summary>
        // 計測対象のサウンドです。
        // </summary>
        public Sound[] Sounds
        {
            get;
        }

        // <summary>
        // 計測された平均ラウドネスの値です。
        // </summary>
        public float[] IntegratedLoudness
        {
            get;
        }

        // <summary>
        // 計測が成功したかどうか。
        // </summary>
        public bool IsSuccess
        {
            get;
        }

        // <summary>
        // 計測が中止されたかどうか。
        // </summary>
        public bool IsCancel
        {
            get;
        }
    }
}
