﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using NW4R.ProtocolSound;

namespace NintendoWare.SoundMaker.Preview.MCS.Viewer
{
    //=========================================================================
    #region MCSビューアテストパケット
    /// <summary>
    /// MCSビューアテストパケット
    /// <para>
    /// ビューアからツールに送られる、テスト用パケットのベースクラスです。
    /// </para>
    /// </summary>
    public abstract class MCSViewerTestPacket : MCSViewerPacket
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        protected MCSViewerTestPacket()
        {
            Debug.Assert( Category == Constants.CATEGORY_TEST );
        }

        /// <summary>
        /// テストパケットの作成
        /// </summary>
        public static MCSViewerTestPacket CreateTestPacket( uint packetType )
        {
            MCSViewerTestPacket packet = null;
            switch ( packetType ) {
            case Constants.VIEWER_TEST_NOP:
                packet = new MCSNOPPacket();
                break;
            }
            return packet;
        }

    }
    #endregion

    //=========================================================================
    #region NOP
    /// <summary>
    /// NOP
    /// <para>
    /// ビューアからの送信をテストするためだけのパケットです。
    /// ビューアに接続後、Zキーサンプルモードに切り替え、Aボタンを押すとこの
    /// パケットがツールに送られます。
    /// </para>
    /// </summary>
    public class MCSNOPPacket : MCSViewerTestPacket
    {
        //---------------------------------------------------------------------
        /// <summary>
        /// 読み込み
        /// </summary>
        public override void Read(
            ProtocolSoundReader reader, MCSPacketHeader header )
        {
            Debug.Assert( header.Size == 0 );
            ShowMessage( "ビューアからテスト用NOPパケットが送られてきました。" );
        }

        //---------------------------------------------------------------------
        /// <summary>
        /// メッセージタイプ
        /// </summary>
        public override ushort PacketType
        {
            get { return Constants.VIEWER_TEST_NOP; }
        }

    }
    #endregion

    //=========================================================================
}
