﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using NW4R.ProtocolSound;

namespace NintendoWare.SoundMaker.Preview.MCS.Viewer
{
    /// <summary>
    /// サウンド用Viewerパケットファクトリー
    /// </summary>
    public class SoundPacketFactory : IViewerPacketFactory
    {
        #region ** IViewerPacketFactory の実装

        ushort IViewerPacketFactory.Category
        {
            get { return Constants.CATEGORY_SOUND; }
        }

        MCSViewerPacket IViewerPacketFactory.CreatePacket( MCSPacketHeader header )
        {
            switch ( header.PacketType ) {
            case Constants.TOOL_SOUND_GET_SOUNDINFORMATIONS:
                return new GetSoundInformationPacket();

            case Constants.TOOL_SOUND_GET_SEQVARIABLES:
                return new GetSeqVariablesPacket();
            }

            return null;
        }

        #endregion
    }
}
