﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Nintendo.Alto.Foundation.Communications
{
    using System;

    /// <summary>
    /// HostIO チャンネル関連イベントのデータを格納します。
    /// </summary>
    public class HostIOChannelEventArgs : EventArgs
    {
        private HostIOChannelInfo channelInfo;

        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="channelInfo">チャンネル情報を指定します。</param>
        public HostIOChannelEventArgs(HostIOChannelInfo channelInfo)
        {
            //Ensure.Argument.NotNull(channelInfo);
            this.channelInfo = channelInfo;
        }

        /// <summary>
        /// チャンネル情報を取得します。
        /// </summary>
        public HostIOChannelInfo ChannelInfo
        {
            get { return this.channelInfo; }
        }
    }
}
