﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using NW4R.ProtocolSound;

namespace NintendoWare.SoundMaker.Preview.Htcs.Tool.Sound
{
    using NintendoWare.SoundMaker.Framework.Preview.Communications;
    using NintendoWare.SoundMaker.Framework.Preview.Communications.Tool;

    internal class HtcsSetEffectParametersPacket : ToolSoundPacket
    {
        private EffectParameterCollection _parameterSets;
        private uint _deviceTypeValue;

        public HtcsSetEffectParametersPacket(EffectParameterCollection parameterSets, uint deviceTypeValue)
        {
            _parameterSets = parameterSets;
            _deviceTypeValue = deviceTypeValue;
        }

        #region ** プロパティのオーバーライド

        /// <summary>
        /// パケットの種類
        /// </summary>
        public override ushort PacketType
        {
            get { return Constants.TOOL_SOUND_SET_EFFECTPARAMETERS; }
        }

        /// <summary>
        /// データサイズ
        /// </summary>
        public override ushort Size
        {
            // DRC 対応
            get { return (ushort)(4 + ToolSoundItemContainer.StructSize + EffectParametersSize); }
        }

        private ushort EffectParametersSize
        {
            get { return (ushort)(ToolSoundEffectCommonParameter.StructSize * _parameterSets.Count); }
        }

        #endregion

        #region ** メソッド

        /// <summary>
        /// パケットを作成して送信します。
        /// </summary>
        /// <param name="effectParam">エフェクトパラメータ</param>
        public static void Send(EffectParameterCollection parameterSets, uint deviceTypeValue)
        {
            if (!CommManager.Instance.IsConnected) { return; }
            SendPacket(new HtcsSetEffectParametersPacket(parameterSets, deviceTypeValue));
        }

        #endregion

        #region ** メソッドのオーバーライド

        /// <summary>
        /// 送信パケットの圧縮
        /// </summary>
        public override bool Compress(ToolPacket nextPacket)
        {
            return (nextPacket is HtcsSetEffectParametersPacket);
        }

        /// <summary>
        /// ストリームからデータを読み込みます。
        /// </summary>
        /// <param name="reader">対象ストリーム</param>
        /// <param name="header">パケットヘッダ</param>
        public override void Read(ProtocolSoundReader reader, CommPacketHeader header)
        {
            // TOOL_SOUND_SET_EFFECTPARAMETER は Write のみ
            Debug.Assert(false, "Don't call is method");
        }

        /// <summary>
        /// ストリームにデータを書き出します。
        /// </summary>
        /// <param name="writer">対象ストリーム</param>
        /// <returns>出力したパケットヘッダ</returns>
        public override CommPacketHeader Write(ProtocolSoundWriter writer)
        {
            Debug.Assert(null != writer, "Writer is null");

            // パケットヘッダを出力する
            CommPacketHeader header = CreateHeader();
            header.Write(writer);

            Debug.Assert(null != _parameterSets, "ParameterSets is null");

            // デバイス情報を出力します。
            // DRC 対応
            writer.Write(_deviceTypeValue);

            //
            // AuxBusエフェクト情報を出力する
            //
            // コンテナヘッダ
            ToolSoundItemContainer container = new ToolSoundItemContainer();

            container.offsetForData = ToolSoundItemContainer.StructSize;
            container.itemCount = (uint)_parameterSets.Count;
            container.itemSize = ToolSoundEffectCommonParameter.StructSize; // サイズは各種エフェクトとも共通

            container.Write(writer);

            // 各エフェクトパラメータ
            foreach (EffectParameterSet item in _parameterSets)
            {
                item.Selected.Write(writer);
            }

            Htcs.Viewer.HtcsSetEffectParametersPacket.Received = false;

            return header;
        }

        #endregion
    }
}
