﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

using NW4R.ProtocolSound;

// preview
//using NW4R_SoundMaker.Preview.Models;


namespace NintendoWare.Preview.HIO.Sound.Viewer
{
  using NintendoWare.Preview.HIO.Sound.Viewer;
  using NintendoWare.SoundMaker.Preview;

  /// <summary>
  /// サウンド情報の取得パケットの基本クラス
  /// </summary>
  public class GetSoundInformationPacket : HIOViewerPacket
  {
      private static PreviewPlayerInformationCollectionGeneric _informations = null;
    private static bool                               _received     = true;

    #region ** プロパティ

    public static PreviewPlayerInformationCollectionGeneric Target
    {
      get { return _informations; }
      set { _informations = value; }
    }

    public static bool Received
    {
      get { return _received; }
      set { _received = value; }
    }

    #endregion

    #region ** プロパティのオーバーライド

    /// <summary>
    /// パケットの種類
    /// </summary>
    public override ushort PacketType
    {
      get { return Constants.TOOL_SOUND_GET_SOUNDINFORMATIONS; }
    }

    #endregion

    #region ** メソッドのオーバーライド

    /// <summary>
    /// ストリームからデータを読み込みます。
    /// </summary>
    /// <param name="reader">対象ストリーム</param>
    /// <param name="header">パケットヘッダ</param>
    public override void Read(ProtocolSoundReader reader, HIOPacketHeader header)
    {
      _received = true;

      // コンテナヘッダを解析する
      ToolSoundItemContainer container = new ToolSoundItemContainer();
      container.Read( reader );

      if( null == _informations ) {
        reader.ReadBytes( header.Size );
        return;
      }

      // プレビュープレイヤー情報を解析する
      for( uint i=0; i<container.itemCount; i++ ) {

        ToolSoundPreviewSoundInfomation information = new ToolSoundPreviewSoundInfomation();
        information.Read( reader );

        if( !_informations.Contains( i ) ) { continue; }

        _informations[ i ].State = (PreviewPlayerState)information.state;

      }
    }

    #endregion
  }
}
